/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search;

import conductor.org.apache.lucene.index.PostingsEnum;
import conductor.org.apache.lucene.search.DocIdSetIterator;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.search.similarities.Similarity;
import java.io.IOException;

final class TermScorer
extends Scorer {
    private final PostingsEnum postingsEnum;
    private final Similarity.SimScorer docScorer;

    TermScorer(Weight weight, PostingsEnum td, Similarity.SimScorer docScorer) {
        super(weight);
        this.docScorer = docScorer;
        this.postingsEnum = td;
    }

    @Override
    public int docID() {
        return this.postingsEnum.docID();
    }

    final int freq() throws IOException {
        return this.postingsEnum.freq();
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.postingsEnum;
    }

    @Override
    public float score() throws IOException {
        assert (this.docID() != Integer.MAX_VALUE);
        return this.docScorer.score(this.postingsEnum.docID(), this.postingsEnum.freq());
    }

    public String toString() {
        return "scorer(" + this.weight + ")[" + super.toString() + "]";
    }
}

