/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.intervals;

import conductor.org.apache.lucene.search.intervals.IntervalIterator;
import java.io.IOException;
import java.util.Objects;

abstract class DifferenceIntervalFunction {
    static final DifferenceIntervalFunction NON_OVERLAPPING = new SingletonFunction("NON_OVERLAPPING"){

        @Override
        public IntervalIterator apply(IntervalIterator minuend, IntervalIterator subtrahend) {
            return new NonOverlappingIterator(minuend, subtrahend);
        }
    };
    static final DifferenceIntervalFunction NOT_CONTAINING = new SingletonFunction("NOT_CONTAINING"){

        @Override
        public IntervalIterator apply(IntervalIterator minuend, IntervalIterator subtrahend) {
            return new NotContainingIterator(minuend, subtrahend);
        }
    };
    static final DifferenceIntervalFunction NOT_CONTAINED_BY = new SingletonFunction("NOT_CONTAINED_BY"){

        @Override
        public IntervalIterator apply(IntervalIterator minuend, IntervalIterator subtrahend) {
            return new NotContainedByIterator(minuend, subtrahend);
        }
    };

    DifferenceIntervalFunction() {
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public abstract IntervalIterator apply(IntervalIterator var1, IntervalIterator var2);

    private static abstract class SingletonFunction
    extends DifferenceIntervalFunction {
        private final String name;

        SingletonFunction(String name) {
            this.name = name;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private static class NotContainedByIterator
    extends RelativeIterator {
        NotContainedByIterator(IntervalIterator a, IntervalIterator b) {
            super(a, b);
        }

        @Override
        public int nextInterval() throws IOException {
            if (!this.bpos) {
                return this.a.nextInterval();
            }
            while (this.a.nextInterval() != Integer.MAX_VALUE) {
                while (this.b.end() < this.a.end()) {
                    if (this.b.nextInterval() != Integer.MAX_VALUE) continue;
                    return this.a.start();
                }
                if (this.a.start() >= this.b.start()) continue;
                return this.a.start();
            }
            return Integer.MAX_VALUE;
        }
    }

    private static class NotContainingIterator
    extends RelativeIterator {
        private NotContainingIterator(IntervalIterator minuend, IntervalIterator subtrahend) {
            super(minuend, subtrahend);
        }

        @Override
        public int nextInterval() throws IOException {
            if (!this.bpos) {
                return this.a.nextInterval();
            }
            while (this.a.nextInterval() != Integer.MAX_VALUE) {
                while (this.b.start() < this.a.start() && this.b.end() < this.a.end()) {
                    if (this.b.nextInterval() != Integer.MAX_VALUE) continue;
                    this.bpos = false;
                    return this.a.start();
                }
                if (this.b.start() <= this.a.end()) continue;
                return this.a.start();
            }
            return Integer.MAX_VALUE;
        }
    }

    static class NotWithinFunction
    extends DifferenceIntervalFunction {
        private final int positions;

        NotWithinFunction(int positions) {
            this.positions = positions;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotWithinFunction that = (NotWithinFunction)o;
            return this.positions == that.positions;
        }

        @Override
        public String toString() {
            return "NOTWITHIN/" + this.positions;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.positions);
        }

        @Override
        public IntervalIterator apply(IntervalIterator minuend, final IntervalIterator subtrahend) {
            IntervalIterator notWithin = new IntervalIterator(){
                boolean positioned = false;

                @Override
                public int docID() {
                    return subtrahend.docID();
                }

                @Override
                public int nextDoc() throws IOException {
                    this.positioned = false;
                    return subtrahend.nextDoc();
                }

                @Override
                public int advance(int target) throws IOException {
                    this.positioned = false;
                    return subtrahend.advance(target);
                }

                @Override
                public long cost() {
                    return subtrahend.cost();
                }

                @Override
                public int start() {
                    if (!this.positioned) {
                        return -1;
                    }
                    int start = subtrahend.start();
                    return Math.max(0, start - positions);
                }

                @Override
                public int end() {
                    if (!this.positioned) {
                        return -1;
                    }
                    int end = subtrahend.end();
                    int newEnd = end + positions;
                    if (newEnd < 0) {
                        return Integer.MAX_VALUE;
                    }
                    return newEnd;
                }

                @Override
                public int nextInterval() throws IOException {
                    if (!this.positioned) {
                        this.positioned = true;
                    }
                    return subtrahend.nextInterval();
                }

                @Override
                public float matchCost() {
                    return subtrahend.matchCost();
                }
            };
            return NON_OVERLAPPING.apply(minuend, notWithin);
        }
    }

    private static class NonOverlappingIterator
    extends RelativeIterator {
        private NonOverlappingIterator(IntervalIterator minuend, IntervalIterator subtrahend) {
            super(minuend, subtrahend);
        }

        @Override
        public int nextInterval() throws IOException {
            if (!this.bpos) {
                return this.a.nextInterval();
            }
            while (this.a.nextInterval() != Integer.MAX_VALUE) {
                while (this.b.end() < this.a.start()) {
                    if (this.b.nextInterval() != Integer.MAX_VALUE) continue;
                    this.bpos = false;
                    return this.a.start();
                }
                if (this.b.start() <= this.a.end()) continue;
                return this.a.start();
            }
            return Integer.MAX_VALUE;
        }
    }

    private static abstract class RelativeIterator
    extends IntervalIterator {
        final IntervalIterator a;
        final IntervalIterator b;
        boolean bpos;

        RelativeIterator(IntervalIterator a, IntervalIterator b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public int docID() {
            return this.a.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int doc = this.a.nextDoc();
            this.reset();
            return doc;
        }

        @Override
        public int advance(int target) throws IOException {
            int doc = this.a.advance(target);
            this.reset();
            return doc;
        }

        @Override
        public long cost() {
            return this.a.cost();
        }

        protected void reset() throws IOException {
            int doc = this.a.docID();
            this.bpos = this.b.docID() == doc || this.b.docID() < doc && this.b.advance(doc) == doc;
        }

        @Override
        public int start() {
            return this.a.start();
        }

        @Override
        public int end() {
            return this.a.end();
        }

        @Override
        public float matchCost() {
            return this.a.matchCost() + this.b.matchCost();
        }
    }
}

