/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.similarities;

import conductor.org.apache.lucene.index.FieldInvertState;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.CollectionStatistics;
import conductor.org.apache.lucene.search.Explanation;
import conductor.org.apache.lucene.search.TermStatistics;
import conductor.org.apache.lucene.search.similarities.BM25Similarity;
import conductor.org.apache.lucene.search.similarities.Similarity;
import conductor.org.apache.lucene.util.BytesRef;
import java.io.IOException;

public class BooleanSimilarity
extends Similarity {
    private static final Similarity BM25_SIM = new BM25Similarity();

    @Override
    public long computeNorm(FieldInvertState state) {
        return BM25_SIM.computeNorm(state);
    }

    @Override
    public Similarity.SimWeight computeWeight(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        return new BooleanWeight(boost);
    }

    @Override
    public Similarity.SimScorer simScorer(Similarity.SimWeight weight, LeafReaderContext context) throws IOException {
        final float boost = ((BooleanWeight)weight).boost;
        return new Similarity.SimScorer(){

            @Override
            public float score(int doc, float freq) throws IOException {
                return boost;
            }

            @Override
            public Explanation explain(int doc, Explanation freq) throws IOException {
                Explanation queryBoostExpl = Explanation.match(boost, "query boost", new Explanation[0]);
                return Explanation.match(queryBoostExpl.getValue(), "score(" + this.getClass().getSimpleName() + ", doc=" + doc + "), computed from:", queryBoostExpl);
            }

            @Override
            public float computeSlopFactor(int distance) {
                return 1.0f;
            }

            @Override
            public float computePayloadFactor(int doc, int start, int end, BytesRef payload) {
                return 1.0f;
            }
        };
    }

    private static class BooleanWeight
    extends Similarity.SimWeight {
        final float boost;

        BooleanWeight(float boost) {
            this.boost = boost;
        }
    }
}

