/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch;

import conductor.org.elasticsearch.ElasticsearchGenerationException;
import conductor.org.elasticsearch.ElasticsearchParseException;
import conductor.org.elasticsearch.ElasticsearchSecurityException;
import conductor.org.elasticsearch.ElasticsearchStatusException;
import conductor.org.elasticsearch.ElasticsearchTimeoutException;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.ResourceAlreadyExistsException;
import conductor.org.elasticsearch.ResourceNotFoundException;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.FailedNodeException;
import conductor.org.elasticsearch.action.NoShardAvailableActionException;
import conductor.org.elasticsearch.action.NoSuchNodeException;
import conductor.org.elasticsearch.action.PrimaryMissingActionException;
import conductor.org.elasticsearch.action.RoutingMissingException;
import conductor.org.elasticsearch.action.TimestampParsingException;
import conductor.org.elasticsearch.action.UnavailableShardsException;
import conductor.org.elasticsearch.action.search.ReduceSearchPhaseException;
import conductor.org.elasticsearch.action.search.SearchPhaseExecutionException;
import conductor.org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import conductor.org.elasticsearch.action.support.replication.ReplicationOperation;
import conductor.org.elasticsearch.action.support.replication.TransportReplicationAction;
import conductor.org.elasticsearch.client.transport.NoNodeAvailableException;
import conductor.org.elasticsearch.cluster.IncompatibleClusterStateVersionException;
import conductor.org.elasticsearch.cluster.NotMasterException;
import conductor.org.elasticsearch.cluster.action.shard.ShardStateAction;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import conductor.org.elasticsearch.cluster.routing.IllegalShardRoutingStateException;
import conductor.org.elasticsearch.cluster.routing.RoutingException;
import conductor.org.elasticsearch.common.CheckedFunction;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.ParsingException;
import conductor.org.elasticsearch.common.blobstore.BlobStoreException;
import conductor.org.elasticsearch.common.breaker.CircuitBreakingException;
import conductor.org.elasticsearch.common.collect.Tuple;
import conductor.org.elasticsearch.common.io.stream.NotSerializableExceptionWrapper;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.logging.LoggerMessageFormat;
import conductor.org.elasticsearch.common.settings.NoClassSettingsException;
import conductor.org.elasticsearch.common.settings.SettingsException;
import conductor.org.elasticsearch.common.util.CancellableThreads;
import conductor.org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.UnknownNamedObjectException;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParseException;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentParserUtils;
import conductor.org.elasticsearch.discovery.Discovery;
import conductor.org.elasticsearch.discovery.MasterNotDiscoveredException;
import conductor.org.elasticsearch.env.ShardLockObtainFailedException;
import conductor.org.elasticsearch.gateway.GatewayException;
import conductor.org.elasticsearch.http.BindHttpException;
import conductor.org.elasticsearch.http.HttpException;
import conductor.org.elasticsearch.index.Index;
import conductor.org.elasticsearch.index.IndexNotFoundException;
import conductor.org.elasticsearch.index.engine.DeleteFailedEngineException;
import conductor.org.elasticsearch.index.engine.DocumentMissingException;
import conductor.org.elasticsearch.index.engine.DocumentSourceMissingException;
import conductor.org.elasticsearch.index.engine.EngineCreationFailureException;
import conductor.org.elasticsearch.index.engine.EngineException;
import conductor.org.elasticsearch.index.engine.FlushFailedEngineException;
import conductor.org.elasticsearch.index.engine.IndexFailedEngineException;
import conductor.org.elasticsearch.index.engine.RecoveryEngineException;
import conductor.org.elasticsearch.index.engine.RefreshFailedEngineException;
import conductor.org.elasticsearch.index.engine.SnapshotFailedEngineException;
import conductor.org.elasticsearch.index.engine.VersionConflictEngineException;
import conductor.org.elasticsearch.index.mapper.MapperException;
import conductor.org.elasticsearch.index.mapper.MapperParsingException;
import conductor.org.elasticsearch.index.mapper.StrictDynamicMappingException;
import conductor.org.elasticsearch.index.query.QueryShardException;
import conductor.org.elasticsearch.index.shard.IllegalIndexShardStateException;
import conductor.org.elasticsearch.index.shard.IndexShardClosedException;
import conductor.org.elasticsearch.index.shard.IndexShardNotRecoveringException;
import conductor.org.elasticsearch.index.shard.IndexShardNotStartedException;
import conductor.org.elasticsearch.index.shard.IndexShardRecoveringException;
import conductor.org.elasticsearch.index.shard.IndexShardRecoveryException;
import conductor.org.elasticsearch.index.shard.IndexShardRelocatedException;
import conductor.org.elasticsearch.index.shard.IndexShardStartedException;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.index.shard.ShardNotFoundException;
import conductor.org.elasticsearch.index.snapshots.IndexShardRestoreException;
import conductor.org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import conductor.org.elasticsearch.index.snapshots.IndexShardSnapshotException;
import conductor.org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import conductor.org.elasticsearch.index.translog.TranslogCorruptedException;
import conductor.org.elasticsearch.index.translog.TranslogException;
import conductor.org.elasticsearch.index.translog.TruncatedTranslogException;
import conductor.org.elasticsearch.indices.AliasFilterParsingException;
import conductor.org.elasticsearch.indices.IndexClosedException;
import conductor.org.elasticsearch.indices.IndexCreationException;
import conductor.org.elasticsearch.indices.IndexPrimaryShardNotAllocatedException;
import conductor.org.elasticsearch.indices.IndexTemplateMissingException;
import conductor.org.elasticsearch.indices.InvalidAliasNameException;
import conductor.org.elasticsearch.indices.InvalidIndexNameException;
import conductor.org.elasticsearch.indices.InvalidIndexTemplateException;
import conductor.org.elasticsearch.indices.InvalidTypeNameException;
import conductor.org.elasticsearch.indices.TypeMissingException;
import conductor.org.elasticsearch.indices.recovery.DelayRecoveryException;
import conductor.org.elasticsearch.indices.recovery.RecoverFilesRecoveryException;
import conductor.org.elasticsearch.indices.recovery.RecoveryFailedException;
import conductor.org.elasticsearch.node.NodeClosedException;
import conductor.org.elasticsearch.repositories.RepositoryException;
import conductor.org.elasticsearch.repositories.RepositoryMissingException;
import conductor.org.elasticsearch.repositories.RepositoryVerificationException;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.rest.action.admin.indices.AliasesNotFoundException;
import conductor.org.elasticsearch.script.GeneralScriptException;
import conductor.org.elasticsearch.script.ScriptException;
import conductor.org.elasticsearch.search.SearchContextException;
import conductor.org.elasticsearch.search.SearchContextMissingException;
import conductor.org.elasticsearch.search.SearchException;
import conductor.org.elasticsearch.search.SearchParseException;
import conductor.org.elasticsearch.search.aggregations.AggregationExecutionException;
import conductor.org.elasticsearch.search.aggregations.AggregationInitializationException;
import conductor.org.elasticsearch.search.aggregations.InvalidAggregationPathException;
import conductor.org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import conductor.org.elasticsearch.search.builder.SearchSourceBuilderException;
import conductor.org.elasticsearch.search.dfs.DfsPhaseExecutionException;
import conductor.org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import conductor.org.elasticsearch.search.query.QueryPhaseExecutionException;
import conductor.org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import conductor.org.elasticsearch.snapshots.InvalidSnapshotNameException;
import conductor.org.elasticsearch.snapshots.SnapshotCreationException;
import conductor.org.elasticsearch.snapshots.SnapshotException;
import conductor.org.elasticsearch.snapshots.SnapshotMissingException;
import conductor.org.elasticsearch.snapshots.SnapshotRestoreException;
import conductor.org.elasticsearch.tasks.TaskCancelledException;
import conductor.org.elasticsearch.transport.ActionNotFoundTransportException;
import conductor.org.elasticsearch.transport.ActionTransportException;
import conductor.org.elasticsearch.transport.BindTransportException;
import conductor.org.elasticsearch.transport.ConnectTransportException;
import conductor.org.elasticsearch.transport.NodeDisconnectedException;
import conductor.org.elasticsearch.transport.NodeNotConnectedException;
import conductor.org.elasticsearch.transport.NodeShouldNotConnectException;
import conductor.org.elasticsearch.transport.NotSerializableTransportException;
import conductor.org.elasticsearch.transport.ReceiveTimeoutTransportException;
import conductor.org.elasticsearch.transport.RemoteTransportException;
import conductor.org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import conductor.org.elasticsearch.transport.SendRequestTransportException;
import conductor.org.elasticsearch.transport.TcpTransport;
import conductor.org.elasticsearch.transport.TransportException;
import conductor.org.elasticsearch.transport.TransportSerializationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ElasticsearchException
extends RuntimeException
implements ToXContentFragment,
Writeable {
    private static final Version UNKNOWN_VERSION_ADDED = Version.fromId(0);
    private static final String REST_EXCEPTION_SKIP_CAUSE = "rest.exception.cause.skip";
    public static final String REST_EXCEPTION_SKIP_STACK_TRACE = "rest.exception.stacktrace.skip";
    public static final boolean REST_EXCEPTION_SKIP_STACK_TRACE_DEFAULT = true;
    private static final boolean REST_EXCEPTION_SKIP_CAUSE_DEFAULT = false;
    private static final String INDEX_METADATA_KEY = "es.index";
    private static final String INDEX_METADATA_KEY_UUID = "es.index_uuid";
    private static final String SHARD_METADATA_KEY = "es.shard";
    private static final String RESOURCE_METADATA_TYPE_KEY = "es.resource.type";
    private static final String RESOURCE_METADATA_ID_KEY = "es.resource.id";
    private static final String TYPE = "type";
    private static final String REASON = "reason";
    private static final String CAUSED_BY = "caused_by";
    private static final ParseField SUPPRESSED = new ParseField("suppressed", new String[0]);
    private static final String STACK_TRACE = "stack_trace";
    private static final String HEADER = "header";
    private static final String ERROR = "error";
    private static final String ROOT_CAUSE = "root_cause";
    private static final Map<Integer, CheckedFunction<StreamInput, ? extends ElasticsearchException, IOException>> ID_TO_SUPPLIER = Collections.unmodifiableMap(Arrays.stream(ElasticsearchExceptionHandle.values()).collect(Collectors.toMap(e -> e.id, e -> e.constructor)));
    private static final Map<Class<? extends ElasticsearchException>, ElasticsearchExceptionHandle> CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE = Collections.unmodifiableMap(Arrays.stream(ElasticsearchExceptionHandle.values()).collect(Collectors.toMap(e -> e.exceptionClass, e -> e)));
    private final Map<String, List<String>> metadata = new HashMap<String, List<String>>();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public ElasticsearchException(Throwable cause) {
        super(cause);
    }

    public ElasticsearchException(String msg, Object ... args) {
        super(LoggerMessageFormat.format(msg, args));
    }

    public ElasticsearchException(String msg, Throwable cause, Object ... args) {
        super(LoggerMessageFormat.format(msg, args), cause);
    }

    public ElasticsearchException(StreamInput in) throws IOException {
        super(in.readOptionalString(), (Throwable)in.readException());
        ElasticsearchException.readStackTrace(this, in);
        this.headers.putAll(in.readMapOfLists(StreamInput::readString, StreamInput::readString));
        if (in.getVersion().onOrAfter(Version.V_5_3_0)) {
            this.metadata.putAll(in.readMapOfLists(StreamInput::readString, StreamInput::readString));
        } else {
            Iterator<Map.Entry<String, List<String>>> iterator = this.headers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, List<String>> header = iterator.next();
                if (!header.getKey().startsWith("es.")) continue;
                this.metadata.put(header.getKey(), header.getValue());
                iterator.remove();
            }
        }
    }

    public void addMetadata(String key, String ... values) {
        this.addMetadata(key, Arrays.asList(values));
    }

    public void addMetadata(String key, List<String> values) {
        if (!key.startsWith("es.")) {
            throw new IllegalArgumentException("exception metadata must start with [es.], found [" + key + "] instead");
        }
        this.metadata.put(key, values);
    }

    public Set<String> getMetadataKeys() {
        return this.metadata.keySet();
    }

    public List<String> getMetadata(String key) {
        return this.metadata.get(key);
    }

    protected Map<String, List<String>> getMetadata() {
        return this.metadata;
    }

    public void addHeader(String key, List<String> value) {
        if (key.startsWith("es.")) {
            throw new IllegalArgumentException("exception headers must not start with [es.], found [" + key + "] instead");
        }
        this.headers.put(key, value);
    }

    public void addHeader(String key, String ... value) {
        this.addHeader(key, Arrays.asList(value));
    }

    public Set<String> getHeaderKeys() {
        return this.headers.keySet();
    }

    public List<String> getHeader(String key) {
        return this.headers.get(key);
    }

    protected Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public RestStatus status() {
        Throwable cause = this.unwrapCause();
        if (cause == this) {
            return RestStatus.INTERNAL_SERVER_ERROR;
        }
        return ExceptionsHelper.status(cause);
    }

    public Throwable unwrapCause() {
        return ExceptionsHelper.unwrapCause(this);
    }

    public String getDetailedMessage() {
        if (this.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString()).append("; ");
            if (this.getCause() instanceof ElasticsearchException) {
                sb.append(((ElasticsearchException)this.getCause()).getDetailedMessage());
            } else {
                sb.append(this.getCause());
            }
            return sb.toString();
        }
        return super.toString();
    }

    public Throwable getRootCause() {
        Throwable rootCause = this;
        for (Throwable cause = this.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.getMessage());
        out.writeException(this.getCause());
        ElasticsearchException.writeStackTraces(this, out);
        if (out.getVersion().onOrAfter(Version.V_5_3_0)) {
            out.writeMapOfLists(this.headers, StreamOutput::writeString, StreamOutput::writeString);
            out.writeMapOfLists(this.metadata, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            HashMap<String, List<String>> finalHeaders = new HashMap<String, List<String>>(this.headers.size() + this.metadata.size());
            finalHeaders.putAll(this.headers);
            finalHeaders.putAll(this.metadata);
            out.writeMapOfLists(finalHeaders, StreamOutput::writeString, StreamOutput::writeString);
        }
    }

    public static ElasticsearchException readException(StreamInput input, int id) throws IOException {
        CheckedFunction<StreamInput, ? extends ElasticsearchException, IOException> elasticsearchException = ID_TO_SUPPLIER.get(id);
        if (elasticsearchException == null) {
            throw new IllegalStateException("unknown exception for id: " + id);
        }
        return elasticsearchException.apply(input);
    }

    public static boolean isRegistered(Class<? extends Throwable> exception, Version version) {
        ElasticsearchExceptionHandle elasticsearchExceptionHandle = CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE.get(exception);
        if (elasticsearchExceptionHandle != null) {
            return version.onOrAfter(elasticsearchExceptionHandle.versionAdded);
        }
        return false;
    }

    static Set<Class<? extends ElasticsearchException>> getRegisteredKeys() {
        return CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE.keySet();
    }

    public static int getId(Class<? extends ElasticsearchException> exception) {
        return ElasticsearchException.CLASS_TO_ELASTICSEARCH_EXCEPTION_HANDLE.get(exception).id;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Throwable ex = ExceptionsHelper.unwrapCause(this);
        if (ex != this) {
            ElasticsearchException.generateThrowableXContent(builder, params, this);
        } else {
            ElasticsearchException.innerToXContent(builder, params, this, this.getExceptionName(), this.getMessage(), this.headers, this.metadata, this.getCause());
        }
        return builder;
    }

    protected static void innerToXContent(XContentBuilder builder, ToXContent.Params params, Throwable throwable, String type, String message, Map<String, List<String>> headers, Map<String, List<String>> metadata, Throwable cause) throws IOException {
        Throwable[] allSuppressed;
        builder.field(TYPE, type);
        builder.field(REASON, message);
        for (Map.Entry<String, List<String>> entry : metadata.entrySet()) {
            ElasticsearchException.headerToXContent(builder, entry.getKey().substring("es.".length()), entry.getValue());
        }
        if (throwable instanceof ElasticsearchException) {
            ElasticsearchException exception = (ElasticsearchException)throwable;
            exception.metadataToXContent(builder, params);
        }
        if (!params.paramAsBoolean(REST_EXCEPTION_SKIP_CAUSE, false) && cause != null) {
            builder.field(CAUSED_BY);
            builder.startObject();
            ElasticsearchException.generateThrowableXContent(builder, params, cause);
            builder.endObject();
        }
        if (!headers.isEmpty()) {
            builder.startObject(HEADER);
            for (Map.Entry entry : headers.entrySet()) {
                ElasticsearchException.headerToXContent(builder, (String)entry.getKey(), (List)entry.getValue());
            }
            builder.endObject();
        }
        if (!params.paramAsBoolean(REST_EXCEPTION_SKIP_STACK_TRACE, true)) {
            builder.field(STACK_TRACE, ExceptionsHelper.stackTrace(throwable));
        }
        if ((allSuppressed = throwable.getSuppressed()).length > 0) {
            builder.startArray(SUPPRESSED.getPreferredName());
            for (Throwable suppressed : allSuppressed) {
                builder.startObject();
                ElasticsearchException.generateThrowableXContent(builder, params, suppressed);
                builder.endObject();
            }
            builder.endArray();
        }
    }

    private static void headerToXContent(XContentBuilder builder, String key, List<String> values) throws IOException {
        if (values != null && !values.isEmpty()) {
            if (values.size() == 1) {
                builder.field(key, values.get(0));
            } else {
                builder.startArray(key);
                for (String value : values) {
                    builder.value(value);
                }
                builder.endArray();
            }
        }
    }

    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public static ElasticsearchException fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser::getTokenLocation);
        return ElasticsearchException.innerFromXContent(parser, false);
    }

    public static ElasticsearchException innerFromXContent(XContentParser parser, boolean parseRootCauses) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser::getTokenLocation);
        String type = null;
        String reason = null;
        String stack = null;
        ElasticsearchException cause = null;
        HashMap<String, List<String>> metadata = new HashMap<String, List<String>>();
        HashMap<String, List<Object>> headers = new HashMap<String, List<Object>>();
        ArrayList<ElasticsearchException> rootCauses = new ArrayList<ElasticsearchException>();
        ArrayList<ElasticsearchException> suppressed = new ArrayList<ElasticsearchException>();
        while (token == XContentParser.Token.FIELD_NAME) {
            List<String> values;
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if (token.isValue()) {
                if (TYPE.equals(currentFieldName)) {
                    type = parser.text();
                } else if (REASON.equals(currentFieldName)) {
                    reason = parser.text();
                } else if (STACK_TRACE.equals(currentFieldName)) {
                    stack = parser.text();
                } else if (token == XContentParser.Token.VALUE_STRING) {
                    metadata.put(currentFieldName, Collections.singletonList(parser.text()));
                }
            } else if (token == XContentParser.Token.START_OBJECT) {
                if (CAUSED_BY.equals(currentFieldName)) {
                    cause = ElasticsearchException.fromXContent(parser);
                } else if (HEADER.equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        values = headers.getOrDefault(currentFieldName, new ArrayList());
                        if (token == XContentParser.Token.VALUE_STRING) {
                            values.add(parser.text());
                        } else if (token == XContentParser.Token.START_ARRAY) {
                            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                if (token == XContentParser.Token.VALUE_STRING) {
                                    values.add(parser.text());
                                    continue;
                                }
                                parser.skipChildren();
                            }
                        } else if (token == XContentParser.Token.START_OBJECT) {
                            parser.skipChildren();
                        }
                        headers.put(currentFieldName, values);
                    }
                } else {
                    parser.skipChildren();
                }
            } else if (token == XContentParser.Token.START_ARRAY) {
                if (parseRootCauses && ROOT_CAUSE.equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        rootCauses.add(ElasticsearchException.fromXContent(parser));
                    }
                } else if (SUPPRESSED.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        suppressed.add(ElasticsearchException.fromXContent(parser));
                    }
                } else {
                    values = new ArrayList();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            values.add(parser.text());
                            continue;
                        }
                        parser.skipChildren();
                    }
                    if (values.size() > 0) {
                        if (metadata.containsKey(currentFieldName)) {
                            values.addAll((Collection)metadata.get(currentFieldName));
                        }
                        metadata.put(currentFieldName, values);
                    }
                }
            }
            token = parser.nextToken();
        }
        ElasticsearchException e = new ElasticsearchException(ElasticsearchException.buildMessage(type, reason, stack), cause, new Object[0]);
        for (Map.Entry entry : metadata.entrySet()) {
            e.addMetadata("es." + (String)entry.getKey(), (List)entry.getValue());
        }
        for (Map.Entry header : headers.entrySet()) {
            e.addHeader((String)header.getKey(), (List)header.getValue());
        }
        for (ElasticsearchException rootCause : rootCauses) {
            e.addSuppressed(rootCause);
        }
        for (ElasticsearchException s : suppressed) {
            e.addSuppressed(s);
        }
        return e;
    }

    public static void generateThrowableXContent(XContentBuilder builder, ToXContent.Params params, Throwable t) throws IOException {
        if ((t = ExceptionsHelper.unwrapCause(t)) instanceof ElasticsearchException) {
            ((ElasticsearchException)t).toXContent(builder, params);
        } else {
            ElasticsearchException.innerToXContent(builder, params, t, ElasticsearchException.getExceptionName(t), t.getMessage(), Collections.emptyMap(), Collections.emptyMap(), t.getCause());
        }
    }

    public static void generateFailureXContent(XContentBuilder builder, ToXContent.Params params, @Nullable Exception e, boolean detailed) throws IOException {
        if (e == null) {
            builder.field(ERROR, "unknown");
            return;
        }
        if (!detailed) {
            String message = "No ElasticsearchException found";
            Throwable t = e;
            for (int counter = 0; counter < 10 && t != null; t = t.getCause(), ++counter) {
                if (!(t instanceof ElasticsearchException)) continue;
                message = t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
                break;
            }
            builder.field(ERROR, message);
            return;
        }
        ElasticsearchException[] rootCauses = ElasticsearchException.guessRootCauses(e);
        builder.startObject(ERROR);
        builder.startArray(ROOT_CAUSE);
        for (ElasticsearchException rootCause : rootCauses) {
            builder.startObject();
            rootCause.toXContent(builder, new ToXContent.DelegatingMapParams(Collections.singletonMap(REST_EXCEPTION_SKIP_CAUSE, "true"), params));
            builder.endObject();
        }
        builder.endArray();
        ElasticsearchException.generateThrowableXContent(builder, params, e);
        builder.endObject();
    }

    public static ElasticsearchException failureFromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureFieldName(parser, token, ERROR);
        token = parser.nextToken();
        if (token.isValue()) {
            return new ElasticsearchException(ElasticsearchException.buildMessage("exception", parser.text(), null), new Object[0]);
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser::getTokenLocation);
        token = parser.nextToken();
        return ElasticsearchException.innerFromXContent(parser, true);
    }

    public ElasticsearchException[] guessRootCauses() {
        Throwable cause = this.getCause();
        if (cause != null && cause instanceof ElasticsearchException) {
            return ((ElasticsearchException)cause).guessRootCauses();
        }
        return new ElasticsearchException[]{this};
    }

    public static ElasticsearchException[] guessRootCauses(Throwable t) {
        Throwable cause;
        Throwable ex = ExceptionsHelper.unwrapCause(t);
        if (ex instanceof ElasticsearchException) {
            return ((ElasticsearchException)ex).guessRootCauses();
        }
        if (ex instanceof XContentParseException && (cause = ex.getCause()) != null && (cause instanceof XContentParseException || cause instanceof ElasticsearchException)) {
            return ElasticsearchException.guessRootCauses(ex.getCause());
        }
        return new ElasticsearchException[]{new ElasticsearchException(t.getMessage(), t, new Object[0]){

            @Override
            protected String getExceptionName() {
                return 1.getExceptionName(this.getCause());
            }
        }};
    }

    protected String getExceptionName() {
        return ElasticsearchException.getExceptionName(this);
    }

    public static String getExceptionName(Throwable ex) {
        String simpleName = ex.getClass().getSimpleName();
        if (simpleName.startsWith("Elasticsearch")) {
            simpleName = simpleName.substring("Elasticsearch".length());
        }
        return ElasticsearchException.toUnderscoreCase(simpleName);
    }

    static String buildMessage(String type, String reason, String stack) {
        StringBuilder message = new StringBuilder("Elasticsearch exception [");
        message.append(TYPE).append('=').append(type).append(", ");
        message.append(REASON).append('=').append(reason);
        if (stack != null) {
            message.append(", ").append(STACK_TRACE).append('=').append(stack);
        }
        message.append(']');
        return message.toString();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.metadata.containsKey(INDEX_METADATA_KEY)) {
            builder.append(this.getIndex());
            if (this.metadata.containsKey(SHARD_METADATA_KEY)) {
                builder.append('[').append(this.getShardId()).append(']');
            }
            builder.append(' ');
        }
        return builder.append(ExceptionsHelper.detailedMessage(this).trim()).toString();
    }

    public static <T extends Throwable> T readStackTrace(T throwable, StreamInput in) throws IOException {
        int stackTraceElements = in.readVInt();
        StackTraceElement[] stackTrace = new StackTraceElement[stackTraceElements];
        for (int i = 0; i < stackTraceElements; ++i) {
            String declaringClasss = in.readString();
            String fileName = in.readOptionalString();
            String methodName = in.readString();
            int lineNumber = in.readVInt();
            stackTrace[i] = new StackTraceElement(declaringClasss, methodName, fileName, lineNumber);
        }
        throwable.setStackTrace(stackTrace);
        int numSuppressed = in.readVInt();
        for (int i = 0; i < numSuppressed; ++i) {
            throwable.addSuppressed((Throwable)in.readException());
        }
        return throwable;
    }

    public static <T extends Throwable> T writeStackTraces(T throwable, StreamOutput out) throws IOException {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        out.writeVInt(stackTrace.length);
        for (StackTraceElement element : stackTrace) {
            out.writeString(element.getClassName());
            out.writeOptionalString(element.getFileName());
            out.writeString(element.getMethodName());
            out.writeVInt(element.getLineNumber());
        }
        Throwable[] suppressed = throwable.getSuppressed();
        out.writeVInt(suppressed.length);
        for (Throwable t : suppressed) {
            out.writeException(t);
        }
        return throwable;
    }

    static int[] ids() {
        return Arrays.stream(ElasticsearchExceptionHandle.values()).mapToInt(h -> h.id).toArray();
    }

    static Tuple<Integer, Class<? extends ElasticsearchException>>[] classes() {
        Tuple[] ts = (Tuple[])Arrays.stream(ElasticsearchExceptionHandle.values()).map(h -> Tuple.tuple(h.id, h.exceptionClass)).toArray(Tuple[]::new);
        return ts;
    }

    public Index getIndex() {
        List<String> index = this.getMetadata(INDEX_METADATA_KEY);
        if (index != null && !index.isEmpty()) {
            List<String> index_uuid = this.getMetadata(INDEX_METADATA_KEY_UUID);
            return new Index(index.get(0), index_uuid.get(0));
        }
        return null;
    }

    public ShardId getShardId() {
        List<String> shard = this.getMetadata(SHARD_METADATA_KEY);
        if (shard != null && !shard.isEmpty()) {
            return new ShardId(this.getIndex(), Integer.parseInt(shard.get(0)));
        }
        return null;
    }

    public void setIndex(Index index) {
        if (index != null) {
            this.addMetadata(INDEX_METADATA_KEY, index.getName());
            this.addMetadata(INDEX_METADATA_KEY_UUID, index.getUUID());
        }
    }

    public void setIndex(String index) {
        if (index != null) {
            this.setIndex(new Index(index, "_na_"));
        }
    }

    public void setShard(ShardId shardId) {
        if (shardId != null) {
            this.setIndex(shardId.getIndex());
            this.addMetadata(SHARD_METADATA_KEY, Integer.toString(shardId.id()));
        }
    }

    public void setResources(String type, String ... id) {
        assert (type != null);
        this.addMetadata(RESOURCE_METADATA_ID_KEY, id);
        this.addMetadata(RESOURCE_METADATA_TYPE_KEY, type);
    }

    public List<String> getResourceId() {
        return this.getMetadata(RESOURCE_METADATA_ID_KEY);
    }

    public String getResourceType() {
        List<String> header = this.getMetadata(RESOURCE_METADATA_TYPE_KEY);
        if (header != null && !header.isEmpty()) {
            assert (header.size() == 1);
            return header.get(0);
        }
        return null;
    }

    private static String toUnderscoreCase(String value) {
        StringBuilder sb = new StringBuilder();
        boolean changed = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!changed) {
                    for (int j = 0; j < i; ++j) {
                        sb.append(value.charAt(j));
                    }
                    changed = true;
                    if (i == 0) {
                        sb.append(Character.toLowerCase(c));
                        continue;
                    }
                    sb.append('_');
                    sb.append(Character.toLowerCase(c));
                    continue;
                }
                sb.append('_');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (!changed) continue;
            sb.append(c);
        }
        if (!changed) {
            return value;
        }
        return sb.toString();
    }

    static /* synthetic */ Version access$000() {
        return UNKNOWN_VERSION_ADDED;
    }

    private static enum ElasticsearchExceptionHandle {
        INDEX_SHARD_SNAPSHOT_FAILED_EXCEPTION(IndexShardSnapshotFailedException.class, IndexShardSnapshotFailedException::new, 0, ElasticsearchException.access$000()),
        DFS_PHASE_EXECUTION_EXCEPTION(DfsPhaseExecutionException.class, DfsPhaseExecutionException::new, 1, ElasticsearchException.access$000()),
        EXECUTION_CANCELLED_EXCEPTION(CancellableThreads.ExecutionCancelledException.class, CancellableThreads.ExecutionCancelledException::new, 2, ElasticsearchException.access$000()),
        MASTER_NOT_DISCOVERED_EXCEPTION(MasterNotDiscoveredException.class, MasterNotDiscoveredException::new, 3, ElasticsearchException.access$000()),
        ELASTICSEARCH_SECURITY_EXCEPTION(ElasticsearchSecurityException.class, ElasticsearchSecurityException::new, 4, ElasticsearchException.access$000()),
        INDEX_SHARD_RESTORE_EXCEPTION(IndexShardRestoreException.class, IndexShardRestoreException::new, 5, ElasticsearchException.access$000()),
        INDEX_CLOSED_EXCEPTION(IndexClosedException.class, IndexClosedException::new, 6, ElasticsearchException.access$000()),
        BIND_HTTP_EXCEPTION(BindHttpException.class, BindHttpException::new, 7, ElasticsearchException.access$000()),
        REDUCE_SEARCH_PHASE_EXCEPTION(ReduceSearchPhaseException.class, ReduceSearchPhaseException::new, 8, ElasticsearchException.access$000()),
        NODE_CLOSED_EXCEPTION(NodeClosedException.class, NodeClosedException::new, 9, ElasticsearchException.access$000()),
        SNAPSHOT_FAILED_ENGINE_EXCEPTION(SnapshotFailedEngineException.class, SnapshotFailedEngineException::new, 10, ElasticsearchException.access$000()),
        SHARD_NOT_FOUND_EXCEPTION(ShardNotFoundException.class, ShardNotFoundException::new, 11, ElasticsearchException.access$000()),
        CONNECT_TRANSPORT_EXCEPTION(ConnectTransportException.class, ConnectTransportException::new, 12, ElasticsearchException.access$000()),
        NOT_SERIALIZABLE_TRANSPORT_EXCEPTION(NotSerializableTransportException.class, NotSerializableTransportException::new, 13, ElasticsearchException.access$000()),
        RESPONSE_HANDLER_FAILURE_TRANSPORT_EXCEPTION(ResponseHandlerFailureTransportException.class, ResponseHandlerFailureTransportException::new, 14, ElasticsearchException.access$000()),
        INDEX_CREATION_EXCEPTION(IndexCreationException.class, IndexCreationException::new, 15, ElasticsearchException.access$000()),
        INDEX_NOT_FOUND_EXCEPTION(IndexNotFoundException.class, IndexNotFoundException::new, 16, ElasticsearchException.access$000()),
        ILLEGAL_SHARD_ROUTING_STATE_EXCEPTION(IllegalShardRoutingStateException.class, IllegalShardRoutingStateException::new, 17, ElasticsearchException.access$000()),
        BROADCAST_SHARD_OPERATION_FAILED_EXCEPTION(BroadcastShardOperationFailedException.class, BroadcastShardOperationFailedException::new, 18, ElasticsearchException.access$000()),
        RESOURCE_NOT_FOUND_EXCEPTION(ResourceNotFoundException.class, ResourceNotFoundException::new, 19, ElasticsearchException.access$000()),
        ACTION_TRANSPORT_EXCEPTION(ActionTransportException.class, ActionTransportException::new, 20, ElasticsearchException.access$000()),
        ELASTICSEARCH_GENERATION_EXCEPTION(ElasticsearchGenerationException.class, ElasticsearchGenerationException::new, 21, ElasticsearchException.access$000()),
        INDEX_SHARD_STARTED_EXCEPTION(IndexShardStartedException.class, IndexShardStartedException::new, 23, ElasticsearchException.access$000()),
        SEARCH_CONTEXT_MISSING_EXCEPTION(SearchContextMissingException.class, SearchContextMissingException::new, 24, ElasticsearchException.access$000()),
        GENERAL_SCRIPT_EXCEPTION(GeneralScriptException.class, GeneralScriptException::new, 25, ElasticsearchException.access$000()),
        SNAPSHOT_CREATION_EXCEPTION(SnapshotCreationException.class, SnapshotCreationException::new, 27, ElasticsearchException.access$000()),
        DELETE_FAILED_ENGINE_EXCEPTION(DeleteFailedEngineException.class, DeleteFailedEngineException::new, 28, ElasticsearchException.access$000()),
        DOCUMENT_MISSING_EXCEPTION(DocumentMissingException.class, DocumentMissingException::new, 29, ElasticsearchException.access$000()),
        SNAPSHOT_EXCEPTION(SnapshotException.class, SnapshotException::new, 30, ElasticsearchException.access$000()),
        INVALID_ALIAS_NAME_EXCEPTION(InvalidAliasNameException.class, InvalidAliasNameException::new, 31, ElasticsearchException.access$000()),
        INVALID_INDEX_NAME_EXCEPTION(InvalidIndexNameException.class, InvalidIndexNameException::new, 32, ElasticsearchException.access$000()),
        INDEX_PRIMARY_SHARD_NOT_ALLOCATED_EXCEPTION(IndexPrimaryShardNotAllocatedException.class, IndexPrimaryShardNotAllocatedException::new, 33, ElasticsearchException.access$000()),
        TRANSPORT_EXCEPTION(TransportException.class, TransportException::new, 34, ElasticsearchException.access$000()),
        ELASTICSEARCH_PARSE_EXCEPTION(ElasticsearchParseException.class, ElasticsearchParseException::new, 35, ElasticsearchException.access$000()),
        SEARCH_EXCEPTION(SearchException.class, SearchException::new, 36, ElasticsearchException.access$000()),
        MAPPER_EXCEPTION(MapperException.class, MapperException::new, 37, ElasticsearchException.access$000()),
        INVALID_TYPE_NAME_EXCEPTION(InvalidTypeNameException.class, InvalidTypeNameException::new, 38, ElasticsearchException.access$000()),
        SNAPSHOT_RESTORE_EXCEPTION(SnapshotRestoreException.class, SnapshotRestoreException::new, 39, ElasticsearchException.access$000()),
        PARSING_EXCEPTION(ParsingException.class, ParsingException::new, 40, ElasticsearchException.access$000()),
        INDEX_SHARD_CLOSED_EXCEPTION(IndexShardClosedException.class, IndexShardClosedException::new, 41, ElasticsearchException.access$000()),
        RECOVER_FILES_RECOVERY_EXCEPTION(RecoverFilesRecoveryException.class, RecoverFilesRecoveryException::new, 42, ElasticsearchException.access$000()),
        TRUNCATED_TRANSLOG_EXCEPTION(TruncatedTranslogException.class, TruncatedTranslogException::new, 43, ElasticsearchException.access$000()),
        RECOVERY_FAILED_EXCEPTION(RecoveryFailedException.class, RecoveryFailedException::new, 44, ElasticsearchException.access$000()),
        INDEX_SHARD_RELOCATED_EXCEPTION(IndexShardRelocatedException.class, IndexShardRelocatedException::new, 45, ElasticsearchException.access$000()),
        NODE_SHOULD_NOT_CONNECT_EXCEPTION(NodeShouldNotConnectException.class, NodeShouldNotConnectException::new, 46, ElasticsearchException.access$000()),
        TRANSLOG_CORRUPTED_EXCEPTION(TranslogCorruptedException.class, TranslogCorruptedException::new, 48, ElasticsearchException.access$000()),
        CLUSTER_BLOCK_EXCEPTION(ClusterBlockException.class, ClusterBlockException::new, 49, ElasticsearchException.access$000()),
        FETCH_PHASE_EXECUTION_EXCEPTION(FetchPhaseExecutionException.class, FetchPhaseExecutionException::new, 50, ElasticsearchException.access$000()),
        VERSION_CONFLICT_ENGINE_EXCEPTION(VersionConflictEngineException.class, VersionConflictEngineException::new, 52, ElasticsearchException.access$000()),
        ENGINE_EXCEPTION(EngineException.class, EngineException::new, 53, ElasticsearchException.access$000()),
        NO_SUCH_NODE_EXCEPTION(NoSuchNodeException.class, NoSuchNodeException::new, 55, ElasticsearchException.access$000()),
        SETTINGS_EXCEPTION(SettingsException.class, SettingsException::new, 56, ElasticsearchException.access$000()),
        INDEX_TEMPLATE_MISSING_EXCEPTION(IndexTemplateMissingException.class, IndexTemplateMissingException::new, 57, ElasticsearchException.access$000()),
        SEND_REQUEST_TRANSPORT_EXCEPTION(SendRequestTransportException.class, SendRequestTransportException::new, 58, ElasticsearchException.access$000()),
        NOT_SERIALIZABLE_EXCEPTION_WRAPPER(NotSerializableExceptionWrapper.class, NotSerializableExceptionWrapper::new, 62, ElasticsearchException.access$000()),
        ALIAS_FILTER_PARSING_EXCEPTION(AliasFilterParsingException.class, AliasFilterParsingException::new, 63, ElasticsearchException.access$000()),
        GATEWAY_EXCEPTION(GatewayException.class, GatewayException::new, 65, ElasticsearchException.access$000()),
        INDEX_SHARD_NOT_RECOVERING_EXCEPTION(IndexShardNotRecoveringException.class, IndexShardNotRecoveringException::new, 66, ElasticsearchException.access$000()),
        HTTP_EXCEPTION(HttpException.class, HttpException::new, 67, ElasticsearchException.access$000()),
        ELASTICSEARCH_EXCEPTION(ElasticsearchException.class, ElasticsearchException::new, 68, ElasticsearchException.access$000()),
        SNAPSHOT_MISSING_EXCEPTION(SnapshotMissingException.class, SnapshotMissingException::new, 69, ElasticsearchException.access$000()),
        PRIMARY_MISSING_ACTION_EXCEPTION(PrimaryMissingActionException.class, PrimaryMissingActionException::new, 70, ElasticsearchException.access$000()),
        FAILED_NODE_EXCEPTION(FailedNodeException.class, FailedNodeException::new, 71, ElasticsearchException.access$000()),
        SEARCH_PARSE_EXCEPTION(SearchParseException.class, SearchParseException::new, 72, ElasticsearchException.access$000()),
        CONCURRENT_SNAPSHOT_EXECUTION_EXCEPTION(ConcurrentSnapshotExecutionException.class, ConcurrentSnapshotExecutionException::new, 73, ElasticsearchException.access$000()),
        BLOB_STORE_EXCEPTION(BlobStoreException.class, BlobStoreException::new, 74, ElasticsearchException.access$000()),
        INCOMPATIBLE_CLUSTER_STATE_VERSION_EXCEPTION(IncompatibleClusterStateVersionException.class, IncompatibleClusterStateVersionException::new, 75, ElasticsearchException.access$000()),
        RECOVERY_ENGINE_EXCEPTION(RecoveryEngineException.class, RecoveryEngineException::new, 76, ElasticsearchException.access$000()),
        UNCATEGORIZED_EXECUTION_EXCEPTION(UncategorizedExecutionException.class, UncategorizedExecutionException::new, 77, ElasticsearchException.access$000()),
        TIMESTAMP_PARSING_EXCEPTION(TimestampParsingException.class, TimestampParsingException::new, 78, ElasticsearchException.access$000()),
        ROUTING_MISSING_EXCEPTION(RoutingMissingException.class, RoutingMissingException::new, 79, ElasticsearchException.access$000()),
        INDEX_FAILED_ENGINE_EXCEPTION(IndexFailedEngineException.class, IndexFailedEngineException::new, 80, ElasticsearchException.access$000()),
        INDEX_SHARD_RESTORE_FAILED_EXCEPTION(IndexShardRestoreFailedException.class, IndexShardRestoreFailedException::new, 81, ElasticsearchException.access$000()),
        REPOSITORY_EXCEPTION(RepositoryException.class, RepositoryException::new, 82, ElasticsearchException.access$000()),
        RECEIVE_TIMEOUT_TRANSPORT_EXCEPTION(ReceiveTimeoutTransportException.class, ReceiveTimeoutTransportException::new, 83, ElasticsearchException.access$000()),
        NODE_DISCONNECTED_EXCEPTION(NodeDisconnectedException.class, NodeDisconnectedException::new, 84, ElasticsearchException.access$000()),
        AGGREGATION_EXECUTION_EXCEPTION(AggregationExecutionException.class, AggregationExecutionException::new, 86, ElasticsearchException.access$000()),
        INVALID_INDEX_TEMPLATE_EXCEPTION(InvalidIndexTemplateException.class, InvalidIndexTemplateException::new, 88, ElasticsearchException.access$000()),
        REFRESH_FAILED_ENGINE_EXCEPTION(RefreshFailedEngineException.class, RefreshFailedEngineException::new, 90, ElasticsearchException.access$000()),
        AGGREGATION_INITIALIZATION_EXCEPTION(AggregationInitializationException.class, AggregationInitializationException::new, 91, ElasticsearchException.access$000()),
        DELAY_RECOVERY_EXCEPTION(DelayRecoveryException.class, DelayRecoveryException::new, 92, ElasticsearchException.access$000()),
        NO_NODE_AVAILABLE_EXCEPTION(NoNodeAvailableException.class, NoNodeAvailableException::new, 94, ElasticsearchException.access$000()),
        INVALID_SNAPSHOT_NAME_EXCEPTION(InvalidSnapshotNameException.class, InvalidSnapshotNameException::new, 96, ElasticsearchException.access$000()),
        ILLEGAL_INDEX_SHARD_STATE_EXCEPTION(IllegalIndexShardStateException.class, IllegalIndexShardStateException::new, 97, ElasticsearchException.access$000()),
        INDEX_SHARD_SNAPSHOT_EXCEPTION(IndexShardSnapshotException.class, IndexShardSnapshotException::new, 98, ElasticsearchException.access$000()),
        INDEX_SHARD_NOT_STARTED_EXCEPTION(IndexShardNotStartedException.class, IndexShardNotStartedException::new, 99, ElasticsearchException.access$000()),
        SEARCH_PHASE_EXECUTION_EXCEPTION(SearchPhaseExecutionException.class, SearchPhaseExecutionException::new, 100, ElasticsearchException.access$000()),
        ACTION_NOT_FOUND_TRANSPORT_EXCEPTION(ActionNotFoundTransportException.class, ActionNotFoundTransportException::new, 101, ElasticsearchException.access$000()),
        TRANSPORT_SERIALIZATION_EXCEPTION(TransportSerializationException.class, TransportSerializationException::new, 102, ElasticsearchException.access$000()),
        REMOTE_TRANSPORT_EXCEPTION(RemoteTransportException.class, RemoteTransportException::new, 103, ElasticsearchException.access$000()),
        ENGINE_CREATION_FAILURE_EXCEPTION(EngineCreationFailureException.class, EngineCreationFailureException::new, 104, ElasticsearchException.access$000()),
        ROUTING_EXCEPTION(RoutingException.class, RoutingException::new, 105, ElasticsearchException.access$000()),
        INDEX_SHARD_RECOVERY_EXCEPTION(IndexShardRecoveryException.class, IndexShardRecoveryException::new, 106, ElasticsearchException.access$000()),
        REPOSITORY_MISSING_EXCEPTION(RepositoryMissingException.class, RepositoryMissingException::new, 107, ElasticsearchException.access$000()),
        DOCUMENT_SOURCE_MISSING_EXCEPTION(DocumentSourceMissingException.class, DocumentSourceMissingException::new, 109, ElasticsearchException.access$000()),
        NO_CLASS_SETTINGS_EXCEPTION(NoClassSettingsException.class, NoClassSettingsException::new, 111, ElasticsearchException.access$000()),
        BIND_TRANSPORT_EXCEPTION(BindTransportException.class, BindTransportException::new, 112, ElasticsearchException.access$000()),
        ALIASES_NOT_FOUND_EXCEPTION(AliasesNotFoundException.class, AliasesNotFoundException::new, 113, ElasticsearchException.access$000()),
        INDEX_SHARD_RECOVERING_EXCEPTION(IndexShardRecoveringException.class, IndexShardRecoveringException::new, 114, ElasticsearchException.access$000()),
        TRANSLOG_EXCEPTION(TranslogException.class, TranslogException::new, 115, ElasticsearchException.access$000()),
        PROCESS_CLUSTER_EVENT_TIMEOUT_EXCEPTION(ProcessClusterEventTimeoutException.class, ProcessClusterEventTimeoutException::new, 116, ElasticsearchException.access$000()),
        RETRY_ON_PRIMARY_EXCEPTION(ReplicationOperation.RetryOnPrimaryException.class, ReplicationOperation.RetryOnPrimaryException::new, 117, ElasticsearchException.access$000()),
        ELASTICSEARCH_TIMEOUT_EXCEPTION(ElasticsearchTimeoutException.class, ElasticsearchTimeoutException::new, 118, ElasticsearchException.access$000()),
        QUERY_PHASE_EXECUTION_EXCEPTION(QueryPhaseExecutionException.class, QueryPhaseExecutionException::new, 119, ElasticsearchException.access$000()),
        REPOSITORY_VERIFICATION_EXCEPTION(RepositoryVerificationException.class, RepositoryVerificationException::new, 120, ElasticsearchException.access$000()),
        INVALID_AGGREGATION_PATH_EXCEPTION(InvalidAggregationPathException.class, InvalidAggregationPathException::new, 121, ElasticsearchException.access$000()),
        RESOURCE_ALREADY_EXISTS_EXCEPTION(ResourceAlreadyExistsException.class, ResourceAlreadyExistsException::new, 123, ElasticsearchException.access$000()),
        HTTP_ON_TRANSPORT_EXCEPTION(TcpTransport.HttpOnTransportException.class, TcpTransport.HttpOnTransportException::new, 125, ElasticsearchException.access$000()),
        MAPPER_PARSING_EXCEPTION(MapperParsingException.class, MapperParsingException::new, 126, ElasticsearchException.access$000()),
        SEARCH_CONTEXT_EXCEPTION(SearchContextException.class, SearchContextException::new, 127, ElasticsearchException.access$000()),
        SEARCH_SOURCE_BUILDER_EXCEPTION(SearchSourceBuilderException.class, SearchSourceBuilderException::new, 128, ElasticsearchException.access$000()),
        NO_SHARD_AVAILABLE_ACTION_EXCEPTION(NoShardAvailableActionException.class, NoShardAvailableActionException::new, 130, ElasticsearchException.access$000()),
        UNAVAILABLE_SHARDS_EXCEPTION(UnavailableShardsException.class, UnavailableShardsException::new, 131, ElasticsearchException.access$000()),
        FLUSH_FAILED_ENGINE_EXCEPTION(FlushFailedEngineException.class, FlushFailedEngineException::new, 132, ElasticsearchException.access$000()),
        CIRCUIT_BREAKING_EXCEPTION(CircuitBreakingException.class, CircuitBreakingException::new, 133, ElasticsearchException.access$000()),
        NODE_NOT_CONNECTED_EXCEPTION(NodeNotConnectedException.class, NodeNotConnectedException::new, 134, ElasticsearchException.access$000()),
        STRICT_DYNAMIC_MAPPING_EXCEPTION(StrictDynamicMappingException.class, StrictDynamicMappingException::new, 135, ElasticsearchException.access$000()),
        RETRY_ON_REPLICA_EXCEPTION(TransportReplicationAction.RetryOnReplicaException.class, TransportReplicationAction.RetryOnReplicaException::new, 136, ElasticsearchException.access$000()),
        TYPE_MISSING_EXCEPTION(TypeMissingException.class, TypeMissingException::new, 137, ElasticsearchException.access$000()),
        FAILED_TO_COMMIT_CLUSTER_STATE_EXCEPTION(Discovery.FailedToCommitClusterStateException.class, Discovery.FailedToCommitClusterStateException::new, 140, ElasticsearchException.access$000()),
        QUERY_SHARD_EXCEPTION(QueryShardException.class, QueryShardException::new, 141, ElasticsearchException.access$000()),
        NO_LONGER_PRIMARY_SHARD_EXCEPTION(ShardStateAction.NoLongerPrimaryShardException.class, ShardStateAction.NoLongerPrimaryShardException::new, 142, ElasticsearchException.access$000()),
        SCRIPT_EXCEPTION(ScriptException.class, ScriptException::new, 143, ElasticsearchException.access$000()),
        NOT_MASTER_EXCEPTION(NotMasterException.class, NotMasterException::new, 144, ElasticsearchException.access$000()),
        STATUS_EXCEPTION(ElasticsearchStatusException.class, ElasticsearchStatusException::new, 145, ElasticsearchException.access$000()),
        TASK_CANCELLED_EXCEPTION(TaskCancelledException.class, TaskCancelledException::new, 146, Version.V_5_1_1),
        SHARD_LOCK_OBTAIN_FAILED_EXCEPTION(ShardLockObtainFailedException.class, ShardLockObtainFailedException::new, 147, Version.V_5_0_2),
        UNKNOWN_NAMED_OBJECT_EXCEPTION(UnknownNamedObjectException.class, UnknownNamedObjectException::new, 148, Version.V_5_2_0),
        TOO_MANY_BUCKETS_EXCEPTION(MultiBucketConsumerService.TooManyBucketsException.class, MultiBucketConsumerService.TooManyBucketsException::new, 149, Version.V_6_2_0);

        final Class<? extends ElasticsearchException> exceptionClass;
        final CheckedFunction<StreamInput, ? extends ElasticsearchException, IOException> constructor;
        final int id;
        final Version versionAdded;

        private <E extends ElasticsearchException> ElasticsearchExceptionHandle(Class<E> exceptionClass, CheckedFunction<StreamInput, E, IOException> constructor, int id, Version versionAdded) {
            this.exceptionClass = exceptionClass;
            this.constructor = constructor;
            this.versionAdded = versionAdded;
            this.id = id;
        }
    }
}

