/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.mapping.get;

import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.bytes.BytesArray;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentFactory;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentParserUtils;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetFieldMappingsResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private static final ObjectParser<Map<String, Map<String, FieldMappingMetaData>>, String> PARSER = new ObjectParser(MAPPINGS.getPreferredName(), true, HashMap::new);
    private Map<String, Map<String, Map<String, FieldMappingMetaData>>> mappings = Collections.emptyMap();

    GetFieldMappingsResponse(Map<String, Map<String, Map<String, FieldMappingMetaData>>> mappings) {
        this.mappings = mappings;
    }

    GetFieldMappingsResponse() {
    }

    public Map<String, Map<String, Map<String, FieldMappingMetaData>>> mappings() {
        return this.mappings;
    }

    public FieldMappingMetaData fieldMappings(String index, String type, String field) {
        Map<String, Map<String, FieldMappingMetaData>> indexMapping = this.mappings.get(index);
        if (indexMapping == null) {
            return null;
        }
        Map<String, FieldMappingMetaData> typeMapping = indexMapping.get(type);
        if (typeMapping == null) {
            return null;
        }
        return typeMapping.get(field);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (Map.Entry<String, Map<String, Map<String, FieldMappingMetaData>>> indexEntry : this.mappings.entrySet()) {
            builder.startObject(indexEntry.getKey());
            builder.startObject(MAPPINGS.getPreferredName());
            for (Map.Entry<String, Map<String, FieldMappingMetaData>> typeEntry : indexEntry.getValue().entrySet()) {
                builder.startObject(typeEntry.getKey());
                for (Map.Entry<String, FieldMappingMetaData> fieldEntry : typeEntry.getValue().entrySet()) {
                    builder.startObject(fieldEntry.getKey());
                    fieldEntry.getValue().toXContent(builder, params);
                    builder.endObject();
                }
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static GetFieldMappingsResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser::getTokenLocation);
        HashMap<String, Map<String, Map<String, FieldMappingMetaData>>> mappings = new HashMap<String, Map<String, Map<String, FieldMappingMetaData>>>();
        if (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
            while (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                String index = parser.currentName();
                Map<String, Map<String, FieldMappingMetaData>> typeMappings = PARSER.parse(parser, index);
                mappings.put(index, typeMappings);
                parser.nextToken();
            }
        }
        return new GetFieldMappingsResponse(mappings);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        HashMap indexMapBuilder = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            String index = in.readString();
            int typesSize = in.readVInt();
            HashMap typeMapBuilder = new HashMap(typesSize);
            for (int j = 0; j < typesSize; ++j) {
                String type = in.readString();
                int fieldSize = in.readVInt();
                HashMap<String, FieldMappingMetaData> fieldMapBuilder = new HashMap<String, FieldMappingMetaData>(fieldSize);
                for (int k = 0; k < fieldSize; ++k) {
                    fieldMapBuilder.put(in.readString(), new FieldMappingMetaData(in.readString(), in.readBytesReference()));
                }
                typeMapBuilder.put(type, Collections.unmodifiableMap(fieldMapBuilder));
            }
            indexMapBuilder.put(index, Collections.unmodifiableMap(typeMapBuilder));
        }
        this.mappings = Collections.unmodifiableMap(indexMapBuilder);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, Map<String, Map<String, FieldMappingMetaData>>> indexEntry : this.mappings.entrySet()) {
            out.writeString(indexEntry.getKey());
            out.writeVInt(indexEntry.getValue().size());
            for (Map.Entry<String, Map<String, FieldMappingMetaData>> typeEntry : indexEntry.getValue().entrySet()) {
                out.writeString(typeEntry.getKey());
                out.writeVInt(typeEntry.getValue().size());
                for (Map.Entry<String, FieldMappingMetaData> fieldEntry : typeEntry.getValue().entrySet()) {
                    out.writeString(fieldEntry.getKey());
                    FieldMappingMetaData fieldMapping = fieldEntry.getValue();
                    out.writeString(fieldMapping.fullName());
                    out.writeBytesReference(fieldMapping.source);
                }
            }
        }
    }

    public String toString() {
        return "GetFieldMappingsResponse{mappings=" + this.mappings + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetFieldMappingsResponse)) {
            return false;
        }
        GetFieldMappingsResponse that = (GetFieldMappingsResponse)o;
        return Objects.equals(this.mappings, that.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.mappings);
    }

    static {
        PARSER.declareField((p, typeMappings, index) -> {
            p.nextToken();
            while (p.currentToken() == XContentParser.Token.FIELD_NAME) {
                String typeName = p.currentName();
                if (p.nextToken() == XContentParser.Token.START_OBJECT) {
                    HashMap<String, FieldMappingMetaData> typeMapping = new HashMap<String, FieldMappingMetaData>();
                    typeMappings.put(typeName, typeMapping);
                    while (p.nextToken() == XContentParser.Token.FIELD_NAME) {
                        String fieldName = p.currentName();
                        FieldMappingMetaData fieldMappingMetaData = FieldMappingMetaData.fromXContent(p);
                        typeMapping.put(fieldName, fieldMappingMetaData);
                    }
                } else {
                    p.skipChildren();
                }
                p.nextToken();
            }
        }, MAPPINGS, ObjectParser.ValueType.OBJECT);
    }

    public static class FieldMappingMetaData
    implements ToXContentFragment {
        public static final FieldMappingMetaData NULL = new FieldMappingMetaData("", BytesArray.EMPTY);
        private static final ParseField FULL_NAME = new ParseField("full_name", new String[0]);
        private static final ParseField MAPPING = new ParseField("mapping", new String[0]);
        private static final ConstructingObjectParser<FieldMappingMetaData, String> PARSER = new ConstructingObjectParser("field_mapping_meta_data", true, a -> new FieldMappingMetaData((String)a[0], (BytesReference)a[1]));
        private String fullName;
        private BytesReference source;

        public FieldMappingMetaData(String fullName, BytesReference source) {
            this.fullName = fullName;
            this.source = source;
        }

        public String fullName() {
            return this.fullName;
        }

        public Map<String, Object> sourceAsMap() {
            return XContentHelper.convertToMap(this.source, true, XContentType.JSON).v2();
        }

        public boolean isNull() {
            return NULL.fullName().equals(this.fullName) && FieldMappingMetaData.NULL.source.length() == this.source.length();
        }

        BytesReference getSource() {
            return this.source;
        }

        public static FieldMappingMetaData fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(FULL_NAME.getPreferredName(), this.fullName);
            if (params.paramAsBoolean("pretty", false)) {
                builder.field("mapping", this.sourceAsMap());
            } else {
                try (StreamInput stream = this.source.streamInput();){
                    builder.rawField(MAPPING.getPreferredName(), stream, XContentType.JSON);
                }
            }
            return builder;
        }

        public String toString() {
            return "FieldMappingMetaData{fullName='" + this.fullName + '\'' + ", source=" + this.source + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldMappingMetaData)) {
                return false;
            }
            FieldMappingMetaData that = (FieldMappingMetaData)o;
            return Objects.equals(this.fullName, that.fullName) && Objects.equals(this.source, that.source);
        }

        public int hashCode() {
            return Objects.hash(this.fullName, this.source);
        }

        static {
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.text(), FULL_NAME, ObjectParser.ValueType.STRING);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                XContentBuilder jsonBuilder = XContentFactory.jsonBuilder().copyCurrentStructure(p);
                BytesReference bytes = BytesReference.bytes(jsonBuilder);
                return bytes;
            }, MAPPING, ObjectParser.ValueType.OBJECT);
        }
    }
}

