/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.cli;

import conductor.org.elasticsearch.cli.SuppressForbidden;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Locale;

public abstract class Terminal {
    public static final Terminal DEFAULT = ConsoleTerminal.isSupported() ? new ConsoleTerminal() : new SystemTerminal();
    private Verbosity verbosity = Verbosity.NORMAL;
    private final String lineSeparator;

    protected Terminal(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public void setVerbosity(Verbosity verbosity) {
        this.verbosity = verbosity;
    }

    public abstract String readText(String var1);

    public abstract char[] readSecret(String var1);

    public abstract PrintWriter getWriter();

    public final void println(String msg) {
        this.println(Verbosity.NORMAL, msg);
    }

    public final void println(Verbosity verbosity, String msg) {
        this.print(verbosity, msg + this.lineSeparator);
    }

    public final void print(Verbosity verbosity, String msg) {
        if (this.isPrintable(verbosity)) {
            this.getWriter().print(msg);
            this.getWriter().flush();
        }
    }

    public final boolean isPrintable(Verbosity verbosity) {
        return this.verbosity.ordinal() >= verbosity.ordinal();
    }

    public final boolean promptYesNo(String prompt, boolean defaultYes) {
        boolean answerYes;
        String answerPrompt;
        String string = answerPrompt = defaultYes ? " [Y/n]" : " [y/N]";
        while (true) {
            String answer;
            if ((answer = this.readText(prompt + answerPrompt)) == null || answer.isEmpty()) {
                return defaultYes;
            }
            answerYes = (answer = answer.toLowerCase(Locale.ROOT)).equals("y");
            if (answerYes || answer.equals("n")) break;
            this.println("Did not understand answer '" + answer + "'");
        }
        return answerYes;
    }

    private static class SystemTerminal
    extends Terminal {
        private static final PrintWriter WRITER = SystemTerminal.newWriter();

        SystemTerminal() {
            super(System.lineSeparator());
        }

        @SuppressForbidden(reason="Writer for System.out")
        private static PrintWriter newWriter() {
            return new PrintWriter(System.out);
        }

        @Override
        public PrintWriter getWriter() {
            return WRITER;
        }

        @Override
        public String readText(String text) {
            this.getWriter().print(text);
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
            try {
                String line = reader.readLine();
                if (line == null) {
                    throw new IllegalStateException("unable to read from standard input; is standard input open and a tty attached?");
                }
                return line;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        @Override
        public char[] readSecret(String text) {
            return this.readText(text).toCharArray();
        }
    }

    private static class ConsoleTerminal
    extends Terminal {
        private static final Console CONSOLE = System.console();

        ConsoleTerminal() {
            super(System.lineSeparator());
        }

        static boolean isSupported() {
            return CONSOLE != null;
        }

        @Override
        public PrintWriter getWriter() {
            return CONSOLE.writer();
        }

        @Override
        public String readText(String prompt) {
            return CONSOLE.readLine("%s", prompt);
        }

        @Override
        public char[] readSecret(String prompt) {
            return CONSOLE.readPassword("%s", prompt);
        }
    }

    public static enum Verbosity {
        SILENT,
        NORMAL,
        VERBOSE;

    }
}

