/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import conductor.org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import conductor.org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import conductor.org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import conductor.org.elasticsearch.action.admin.cluster.repositories.verify.VerifyRepositoryRequest;
import conductor.org.elasticsearch.action.admin.cluster.repositories.verify.VerifyRepositoryResponse;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusResponse;
import conductor.org.elasticsearch.action.support.master.AcknowledgedResponse;
import conductor.org.elasticsearch.client.RequestOptions;
import conductor.org.elasticsearch.client.RestHighLevelClient;
import conductor.org.elasticsearch.client.SnapshotRequestConverters;
import java.io.IOException;
import java.util.Collections;

public final class SnapshotClient {
    private final RestHighLevelClient restHighLevelClient;

    SnapshotClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public GetRepositoriesResponse getRepository(GetRepositoriesRequest getRepositoriesRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(getRepositoriesRequest, SnapshotRequestConverters::getRepositories, options, GetRepositoriesResponse::fromXContent, Collections.emptySet());
    }

    public void getRepositoryAsync(GetRepositoriesRequest getRepositoriesRequest, RequestOptions options, ActionListener<GetRepositoriesResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(getRepositoriesRequest, SnapshotRequestConverters::getRepositories, options, GetRepositoriesResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse createRepository(PutRepositoryRequest putRepositoryRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(putRepositoryRequest, SnapshotRequestConverters::createRepository, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void createRepositoryAsync(PutRepositoryRequest putRepositoryRequest, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(putRepositoryRequest, SnapshotRequestConverters::createRepository, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(deleteRepositoryRequest, SnapshotRequestConverters::deleteRepository, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void deleteRepositoryAsync(DeleteRepositoryRequest deleteRepositoryRequest, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(deleteRepositoryRequest, SnapshotRequestConverters::deleteRepository, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public VerifyRepositoryResponse verifyRepository(VerifyRepositoryRequest verifyRepositoryRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(verifyRepositoryRequest, SnapshotRequestConverters::verifyRepository, options, VerifyRepositoryResponse::fromXContent, Collections.emptySet());
    }

    public void verifyRepositoryAsync(VerifyRepositoryRequest verifyRepositoryRequest, RequestOptions options, ActionListener<VerifyRepositoryResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(verifyRepositoryRequest, SnapshotRequestConverters::verifyRepository, options, VerifyRepositoryResponse::fromXContent, listener, Collections.emptySet());
    }

    public CreateSnapshotResponse create(CreateSnapshotRequest createSnapshotRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(createSnapshotRequest, SnapshotRequestConverters::createSnapshot, options, CreateSnapshotResponse::fromXContent, Collections.emptySet());
    }

    public void createAsync(CreateSnapshotRequest createSnapshotRequest, RequestOptions options, ActionListener<CreateSnapshotResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(createSnapshotRequest, SnapshotRequestConverters::createSnapshot, options, CreateSnapshotResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetSnapshotsResponse get(GetSnapshotsRequest getSnapshotsRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(getSnapshotsRequest, SnapshotRequestConverters::getSnapshots, options, GetSnapshotsResponse::fromXContent, Collections.emptySet());
    }

    public void getAsync(GetSnapshotsRequest getSnapshotsRequest, RequestOptions options, ActionListener<GetSnapshotsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(getSnapshotsRequest, SnapshotRequestConverters::getSnapshots, options, GetSnapshotsResponse::fromXContent, listener, Collections.emptySet());
    }

    public SnapshotsStatusResponse status(SnapshotsStatusRequest snapshotsStatusRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(snapshotsStatusRequest, SnapshotRequestConverters::snapshotsStatus, options, SnapshotsStatusResponse::fromXContent, Collections.emptySet());
    }

    public void statusAsync(SnapshotsStatusRequest snapshotsStatusRequest, RequestOptions options, ActionListener<SnapshotsStatusResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(snapshotsStatusRequest, SnapshotRequestConverters::snapshotsStatus, options, SnapshotsStatusResponse::fromXContent, listener, Collections.emptySet());
    }

    public RestoreSnapshotResponse restore(RestoreSnapshotRequest restoreSnapshotRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(restoreSnapshotRequest, SnapshotRequestConverters::restoreSnapshot, options, RestoreSnapshotResponse::fromXContent, Collections.emptySet());
    }

    public void restoreAsync(RestoreSnapshotRequest restoreSnapshotRequest, RequestOptions options, ActionListener<RestoreSnapshotResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(restoreSnapshotRequest, SnapshotRequestConverters::restoreSnapshot, options, RestoreSnapshotResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse delete(DeleteSnapshotRequest deleteSnapshotRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(deleteSnapshotRequest, SnapshotRequestConverters::deleteSnapshot, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void deleteAsync(DeleteSnapshotRequest deleteSnapshotRequest, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(deleteSnapshotRequest, SnapshotRequestConverters::deleteSnapshot, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }
}

