/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.cluster;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.cluster.Diff;
import conductor.org.elasticsearch.cluster.DiffableUtils;
import conductor.org.elasticsearch.cluster.NamedDiff;
import conductor.org.elasticsearch.cluster.NamedDiffable;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import java.io.IOException;

public class NamedDiffableValueSerializer<T extends NamedDiffable<T>>
extends DiffableUtils.DiffableValueSerializer<String, T> {
    private final Class<T> tClass;

    public NamedDiffableValueSerializer(Class<T> tClass) {
        this.tClass = tClass;
    }

    @Override
    public T read(StreamInput in, String key) throws IOException {
        return (T)((NamedDiffable)in.readNamedWriteable(this.tClass, key));
    }

    @Override
    public boolean supportsVersion(Diff<T> value, Version version) {
        return version.onOrAfter(((NamedDiff)value).getMinimalSupportedVersion());
    }

    @Override
    public boolean supportsVersion(T value, Version version) {
        return version.onOrAfter(value.getMinimalSupportedVersion());
    }

    @Override
    public Diff<T> readDiff(StreamInput in, String key) throws IOException {
        return in.readNamedWriteable(NamedDiff.class, key);
    }
}

