/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.cluster.routing;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.metadata.IndexMetaData;
import conductor.org.elasticsearch.cluster.node.DiscoveryNodes;
import conductor.org.elasticsearch.cluster.routing.GroupShardsIterator;
import conductor.org.elasticsearch.cluster.routing.IndexRoutingTable;
import conductor.org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import conductor.org.elasticsearch.cluster.routing.Murmur3HashFunction;
import conductor.org.elasticsearch.cluster.routing.Preference;
import conductor.org.elasticsearch.cluster.routing.ShardIterator;
import conductor.org.elasticsearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.component.AbstractComponent;
import conductor.org.elasticsearch.common.settings.ClusterSettings;
import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.IndexNotFoundException;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.index.shard.ShardNotFoundException;
import conductor.org.elasticsearch.node.ResponseCollectorService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OperationRouting
extends AbstractComponent {
    public static final Setting<Boolean> USE_ADAPTIVE_REPLICA_SELECTION_SETTING = Setting.boolSetting("cluster.routing.use_adaptive_replica_selection", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private List<String> awarenessAttributes;
    private boolean useAdaptiveReplicaSelection;
    private static final Map<String, Set<String>> EMPTY_ROUTING = Collections.emptyMap();

    public OperationRouting(Settings settings, ClusterSettings clusterSettings) {
        super(settings);
        this.awarenessAttributes = AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.get(settings);
        this.useAdaptiveReplicaSelection = USE_ADAPTIVE_REPLICA_SELECTION_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING, this::setAwarenessAttributes);
        clusterSettings.addSettingsUpdateConsumer(USE_ADAPTIVE_REPLICA_SELECTION_SETTING, this::setUseAdaptiveReplicaSelection);
    }

    void setUseAdaptiveReplicaSelection(boolean useAdaptiveReplicaSelection) {
        this.useAdaptiveReplicaSelection = useAdaptiveReplicaSelection;
    }

    private void setAwarenessAttributes(List<String> awarenessAttributes) {
        this.awarenessAttributes = awarenessAttributes;
    }

    public ShardIterator indexShards(ClusterState clusterState, String index, String id, @Nullable String routing) {
        return this.shards(clusterState, index, id, routing).shardsIt();
    }

    public ShardIterator getShards(ClusterState clusterState, String index, String id, @Nullable String routing, @Nullable String preference) {
        return this.preferenceActiveShardIterator(this.shards(clusterState, index, id, routing), clusterState.nodes().getLocalNodeId(), clusterState.nodes(), preference, null, null);
    }

    public ShardIterator getShards(ClusterState clusterState, String index, int shardId, @Nullable String preference) {
        IndexShardRoutingTable indexShard = clusterState.getRoutingTable().shardRoutingTable(index, shardId);
        return this.preferenceActiveShardIterator(indexShard, clusterState.nodes().getLocalNodeId(), clusterState.nodes(), preference, null, null);
    }

    public GroupShardsIterator<ShardIterator> searchShards(ClusterState clusterState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing, @Nullable String preference) {
        return this.searchShards(clusterState, concreteIndices, routing, preference, null, null);
    }

    public GroupShardsIterator<ShardIterator> searchShards(ClusterState clusterState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing, @Nullable String preference, @Nullable ResponseCollectorService collectorService, @Nullable Map<String, Long> nodeCounts) {
        Set<IndexShardRoutingTable> shards = this.computeTargetedShards(clusterState, concreteIndices, routing);
        HashSet<ShardIterator> set = new HashSet<ShardIterator>(shards.size());
        for (IndexShardRoutingTable shard : shards) {
            ShardIterator iterator = this.preferenceActiveShardIterator(shard, clusterState.nodes().getLocalNodeId(), clusterState.nodes(), preference, collectorService, nodeCounts);
            if (iterator == null) continue;
            set.add(iterator);
        }
        return new GroupShardsIterator<ShardIterator>(new ArrayList(set));
    }

    private Set<IndexShardRoutingTable> computeTargetedShards(ClusterState clusterState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing) {
        routing = routing == null ? EMPTY_ROUTING : routing;
        HashSet<IndexShardRoutingTable> set = new HashSet<IndexShardRoutingTable>();
        for (String index : concreteIndices) {
            IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index);
            IndexMetaData indexMetaData = this.indexMetaData(clusterState, index);
            Set<String> effectiveRouting = routing.get(index);
            if (effectiveRouting != null) {
                for (String r : effectiveRouting) {
                    int routingPartitionSize = indexMetaData.getRoutingPartitionSize();
                    for (int partitionOffset = 0; partitionOffset < routingPartitionSize; ++partitionOffset) {
                        set.add(this.shardRoutingTable(indexRouting, OperationRouting.calculateScaledShardId(indexMetaData, r, partitionOffset)));
                    }
                }
                continue;
            }
            for (IndexShardRoutingTable indexShard : indexRouting) {
                set.add(indexShard);
            }
        }
        return set;
    }

    private ShardIterator preferenceActiveShardIterator(IndexShardRoutingTable indexShard, String localNodeId, DiscoveryNodes nodes, @Nullable String preference, @Nullable ResponseCollectorService collectorService, @Nullable Map<String, Long> nodeCounts) {
        if (preference == null || preference.isEmpty()) {
            if (this.awarenessAttributes.isEmpty()) {
                if (this.useAdaptiveReplicaSelection) {
                    return indexShard.activeInitializingShardsRankedIt(collectorService, nodeCounts);
                }
                return indexShard.activeInitializingShardsRandomIt();
            }
            return indexShard.preferAttributesActiveInitializingShardsIt(this.awarenessAttributes, nodes);
        }
        if (preference.charAt(0) == '_') {
            Preference preferenceType = Preference.parse(preference);
            if (preferenceType == Preference.SHARDS) {
                int index = preference.indexOf(124);
                String shards = index == -1 ? preference.substring(Preference.SHARDS.type().length() + 1) : preference.substring(Preference.SHARDS.type().length() + 1, index);
                String[] ids = Strings.splitStringByCommaToArray(shards);
                boolean found = false;
                for (String id : ids) {
                    if (Integer.parseInt(id) != indexShard.shardId().id()) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return null;
                }
                if (index == -1 || index == preference.length() - 1) {
                    if (this.awarenessAttributes.isEmpty()) {
                        if (this.useAdaptiveReplicaSelection) {
                            return indexShard.activeInitializingShardsRankedIt(collectorService, nodeCounts);
                        }
                        return indexShard.activeInitializingShardsRandomIt();
                    }
                    return indexShard.preferAttributesActiveInitializingShardsIt(this.awarenessAttributes, nodes);
                }
                preference = preference.substring(index + 1);
            }
            preferenceType = Preference.parse(preference);
            switch (preferenceType) {
                case PREFER_NODES: {
                    Set<String> nodesIds = Arrays.stream(preference.substring(Preference.PREFER_NODES.type().length() + 1).split(",")).collect(Collectors.toSet());
                    return indexShard.preferNodeActiveInitializingShardsIt(nodesIds);
                }
                case LOCAL: {
                    return indexShard.preferNodeActiveInitializingShardsIt(Collections.singleton(localNodeId));
                }
                case PRIMARY: {
                    this.deprecationLogger.deprecated("[_primary] has been deprecated in 6.1+, and will be removed in 7.0; use [_only_nodes] or [_prefer_nodes]", new Object[0]);
                    return indexShard.primaryActiveInitializingShardIt();
                }
                case REPLICA: {
                    this.deprecationLogger.deprecated("[_replica] has been deprecated in 6.1+, and will be removed in 7.0; use [_only_nodes] or [_prefer_nodes]", new Object[0]);
                    return indexShard.replicaActiveInitializingShardIt();
                }
                case PRIMARY_FIRST: {
                    this.deprecationLogger.deprecated("[_primary_first] has been deprecated in 6.1+, and will be removed in 7.0; use [_only_nodes] or [_prefer_nodes]", new Object[0]);
                    return indexShard.primaryFirstActiveInitializingShardsIt();
                }
                case REPLICA_FIRST: {
                    this.deprecationLogger.deprecated("[_replica_first] has been deprecated in 6.1+, and will be removed in 7.0; use [_only_nodes] or [_prefer_nodes]", new Object[0]);
                    return indexShard.replicaFirstActiveInitializingShardsIt();
                }
                case ONLY_LOCAL: {
                    return indexShard.onlyNodeActiveInitializingShardsIt(localNodeId);
                }
                case ONLY_NODES: {
                    String nodeAttributes = preference.substring(Preference.ONLY_NODES.type().length() + 1);
                    return indexShard.onlyNodeSelectorActiveInitializingShardsIt(nodeAttributes.split(","), nodes);
                }
            }
            throw new IllegalArgumentException("unknown preference [" + (Object)((Object)preferenceType) + "]");
        }
        int routingHash = Murmur3HashFunction.hash(preference);
        if (nodes.getMinNodeVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            routingHash = 31 * routingHash + indexShard.shardId.hashCode();
        }
        if (this.awarenessAttributes.isEmpty()) {
            return indexShard.activeInitializingShardsIt(routingHash);
        }
        return indexShard.preferAttributesActiveInitializingShardsIt(this.awarenessAttributes, nodes, routingHash);
    }

    private IndexShardRoutingTable shardRoutingTable(IndexRoutingTable indexRouting, int shardId) {
        IndexShardRoutingTable indexShard = indexRouting.shard(shardId);
        if (indexShard == null) {
            throw new ShardNotFoundException(new ShardId(indexRouting.getIndex(), shardId));
        }
        return indexShard;
    }

    protected IndexRoutingTable indexRoutingTable(ClusterState clusterState, String index) {
        IndexRoutingTable indexRouting = clusterState.routingTable().index(index);
        if (indexRouting == null) {
            throw new IndexNotFoundException(index);
        }
        return indexRouting;
    }

    protected IndexMetaData indexMetaData(ClusterState clusterState, String index) {
        IndexMetaData indexMetaData = clusterState.metaData().index(index);
        if (indexMetaData == null) {
            throw new IndexNotFoundException(index);
        }
        return indexMetaData;
    }

    protected IndexShardRoutingTable shards(ClusterState clusterState, String index, String id, String routing) {
        int shardId = OperationRouting.generateShardId(this.indexMetaData(clusterState, index), id, routing);
        return clusterState.getRoutingTable().shardRoutingTable(index, shardId);
    }

    public ShardId shardId(ClusterState clusterState, String index, String id, @Nullable String routing) {
        IndexMetaData indexMetaData = this.indexMetaData(clusterState, index);
        return new ShardId(indexMetaData.getIndex(), OperationRouting.generateShardId(indexMetaData, id, routing));
    }

    public static int generateShardId(IndexMetaData indexMetaData, @Nullable String id, @Nullable String routing) {
        String effectiveRouting;
        if (routing == null) {
            assert (!indexMetaData.isRoutingPartitionedIndex()) : "A routing value is required for gets from a partitioned index";
            effectiveRouting = id;
        } else {
            effectiveRouting = routing;
        }
        int partitionOffset = indexMetaData.isRoutingPartitionedIndex() ? Math.floorMod(Murmur3HashFunction.hash(id), indexMetaData.getRoutingPartitionSize()) : 0;
        return OperationRouting.calculateScaledShardId(indexMetaData, effectiveRouting, partitionOffset);
    }

    private static int calculateScaledShardId(IndexMetaData indexMetaData, String effectiveRouting, int partitionOffset) {
        int hash = Murmur3HashFunction.hash(effectiveRouting) + partitionOffset;
        return Math.floorMod(hash, indexMetaData.getRoutingNumShards()) / indexMetaData.getRoutingFactor();
    }
}

