/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.lucene.search;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.Collector;
import conductor.org.apache.lucene.search.FilterLeafCollector;
import conductor.org.apache.lucene.search.LeafCollector;
import conductor.org.apache.lucene.search.ScorerSupplier;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.util.Bits;
import conductor.org.elasticsearch.common.lucene.Lucene;
import java.io.IOException;

public class FilteredCollector
implements Collector {
    private final Collector collector;
    private final Weight filter;

    public FilteredCollector(Collector collector, Weight filter) {
        this.collector = collector;
        this.filter = filter;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        ScorerSupplier filterScorerSupplier = this.filter.scorerSupplier(context);
        LeafCollector in = this.collector.getLeafCollector(context);
        final Bits bits = Lucene.asSequentialAccessBits(context.reader().maxDoc(), filterScorerSupplier);
        return new FilterLeafCollector(in){

            @Override
            public void collect(int doc) throws IOException {
                if (bits.get(doc)) {
                    this.in.collect(doc);
                }
            }
        };
    }

    @Override
    public boolean needsScores() {
        return this.collector.needsScores();
    }
}

