/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.settings;

import conductor.joptsimple.OptionSet;
import conductor.org.elasticsearch.cli.EnvironmentAwareCommand;
import conductor.org.elasticsearch.cli.Terminal;
import conductor.org.elasticsearch.cli.UserException;
import conductor.org.elasticsearch.common.settings.KeyStoreWrapper;
import conductor.org.elasticsearch.env.Environment;
import java.util.ArrayList;
import java.util.Collections;

class ListKeyStoreCommand
extends EnvironmentAwareCommand {
    ListKeyStoreCommand() {
        super("List entries in the keystore");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        KeyStoreWrapper keystore = KeyStoreWrapper.load(env.configFile());
        if (keystore == null) {
            throw new UserException(65, "Elasticsearch keystore not found. Use 'create' command to create one.");
        }
        keystore.decrypt(new char[0]);
        ArrayList<String> sortedEntries = new ArrayList<String>(keystore.getSettingNames());
        Collections.sort(sortedEntries);
        for (String entry : sortedEntries) {
            terminal.println(entry);
        }
    }
}

