/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.analysis;

import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.hunspell.Dictionary;
import conductor.org.apache.lucene.analysis.hunspell.HunspellStemFilter;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import conductor.org.elasticsearch.indices.analysis.HunspellService;
import java.util.Locale;

public class HunspellTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Dictionary dictionary;
    private final boolean dedup;
    private final boolean longestOnly;

    public HunspellTokenFilterFactory(IndexSettings indexSettings, String name, Settings settings, HunspellService hunspellService) {
        super(indexSettings, name, settings);
        String locale = settings.get("locale", settings.get("language", settings.get("lang", null)));
        if (locale == null) {
            throw new IllegalArgumentException("missing [locale | language | lang] configuration for hunspell token filter");
        }
        this.dictionary = hunspellService.getDictionary(locale);
        if (this.dictionary == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown hunspell dictionary for locale [%s]", locale));
        }
        this.dedup = settings.getAsBooleanLenientForPreEs6Indices(indexSettings.getIndexVersionCreated(), "dedup", true, this.deprecationLogger);
        this.longestOnly = settings.getAsBooleanLenientForPreEs6Indices(indexSettings.getIndexVersionCreated(), "longest_only", false, this.deprecationLogger);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new HunspellStemFilter(tokenStream, this.dictionary, this.dedup, this.longestOnly);
    }

    public boolean dedup() {
        return this.dedup;
    }

    public boolean longestOnly() {
        return this.longestOnly;
    }
}

