/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.analysis;

import conductor.org.elasticsearch.core.internal.io.IOUtils;
import conductor.org.elasticsearch.index.AbstractIndexComponent;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.analysis.AnalyzerScope;
import conductor.org.elasticsearch.index.analysis.NamedAnalyzer;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Stream;

public final class IndexAnalyzers
extends AbstractIndexComponent
implements Closeable {
    private final NamedAnalyzer defaultIndexAnalyzer;
    private final NamedAnalyzer defaultSearchAnalyzer;
    private final NamedAnalyzer defaultSearchQuoteAnalyzer;
    private final Map<String, NamedAnalyzer> analyzers;
    private final Map<String, NamedAnalyzer> normalizers;
    private final Map<String, NamedAnalyzer> whitespaceNormalizers;
    private final IndexSettings indexSettings;

    public IndexAnalyzers(IndexSettings indexSettings, NamedAnalyzer defaultIndexAnalyzer, NamedAnalyzer defaultSearchAnalyzer, NamedAnalyzer defaultSearchQuoteAnalyzer, Map<String, NamedAnalyzer> analyzers, Map<String, NamedAnalyzer> normalizers, Map<String, NamedAnalyzer> whitespaceNormalizers) {
        super(indexSettings);
        this.defaultIndexAnalyzer = defaultIndexAnalyzer;
        this.defaultSearchAnalyzer = defaultSearchAnalyzer;
        this.defaultSearchQuoteAnalyzer = defaultSearchQuoteAnalyzer;
        this.analyzers = analyzers;
        this.normalizers = normalizers;
        this.whitespaceNormalizers = whitespaceNormalizers;
        this.indexSettings = indexSettings;
    }

    public NamedAnalyzer get(String name) {
        return this.analyzers.get(name);
    }

    public NamedAnalyzer getNormalizer(String name) {
        return this.normalizers.get(name);
    }

    public NamedAnalyzer getWhitespaceNormalizer(String name) {
        return this.whitespaceNormalizers.get(name);
    }

    public NamedAnalyzer getDefaultIndexAnalyzer() {
        return this.defaultIndexAnalyzer;
    }

    public NamedAnalyzer getDefaultSearchAnalyzer() {
        return this.defaultSearchAnalyzer;
    }

    public NamedAnalyzer getDefaultSearchQuoteAnalyzer() {
        return this.defaultSearchQuoteAnalyzer;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(() -> Stream.concat(this.analyzers.values().stream(), this.normalizers.values().stream()).filter(a -> a.scope() == AnalyzerScope.INDEX).iterator());
    }

    @Override
    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }
}

