/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.engine;

import conductor.org.elasticsearch.common.lease.Releasable;
import conductor.org.elasticsearch.index.store.Store;
import java.util.concurrent.atomic.AtomicInteger;

public class RecoveryCounter
implements Releasable {
    private final Store store;
    private final AtomicInteger onGoingRecoveries = new AtomicInteger();

    RecoveryCounter(Store store) {
        this.store = store;
    }

    void startRecovery() {
        this.store.incRef();
        this.onGoingRecoveries.incrementAndGet();
    }

    public int get() {
        return this.onGoingRecoveries.get();
    }

    int endRecovery() {
        this.store.decRef();
        int left = this.onGoingRecoveries.decrementAndGet();
        assert (this.onGoingRecoveries.get() >= 0) : "ongoingRecoveries must be >= 0 but was: " + this.onGoingRecoveries.get();
        return left;
    }

    @Override
    public void close() {
        this.endRecovery();
    }
}

