/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fielddata;

import conductor.org.elasticsearch.common.FieldMemoryStats;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Streamable;
import conductor.org.elasticsearch.common.unit.ByteSizeValue;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Objects;

public class FieldDataStats
implements Streamable,
ToXContentFragment {
    private static final String FIELDDATA = "fielddata";
    private static final String MEMORY_SIZE = "memory_size";
    private static final String MEMORY_SIZE_IN_BYTES = "memory_size_in_bytes";
    private static final String EVICTIONS = "evictions";
    private static final String FIELDS = "fields";
    long memorySize;
    long evictions;
    @Nullable
    FieldMemoryStats fields;

    public FieldDataStats() {
    }

    public FieldDataStats(long memorySize, long evictions, @Nullable FieldMemoryStats fields) {
        this.memorySize = memorySize;
        this.evictions = evictions;
        this.fields = fields;
    }

    public void add(FieldDataStats stats) {
        this.memorySize += stats.memorySize;
        this.evictions += stats.evictions;
        if (stats.fields != null) {
            if (this.fields == null) {
                this.fields = stats.fields.copy();
            } else {
                this.fields.add(stats.fields);
            }
        }
    }

    public long getMemorySizeInBytes() {
        return this.memorySize;
    }

    public ByteSizeValue getMemorySize() {
        return new ByteSizeValue(this.memorySize);
    }

    public long getEvictions() {
        return this.evictions;
    }

    @Nullable
    public FieldMemoryStats getFields() {
        return this.fields;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.memorySize = in.readVLong();
        this.evictions = in.readVLong();
        this.fields = in.readOptionalWriteable(FieldMemoryStats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.memorySize);
        out.writeVLong(this.evictions);
        out.writeOptionalWriteable(this.fields);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(FIELDDATA);
        builder.humanReadableField(MEMORY_SIZE_IN_BYTES, MEMORY_SIZE, this.getMemorySize());
        builder.field(EVICTIONS, this.getEvictions());
        if (this.fields != null) {
            this.fields.toXContent(builder, FIELDS, MEMORY_SIZE_IN_BYTES, MEMORY_SIZE);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDataStats that = (FieldDataStats)o;
        return this.memorySize == that.memorySize && this.evictions == that.evictions && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.memorySize, this.evictions, this.fields);
    }
}

