/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fielddata.fieldcomparator;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.NumericDocValues;
import conductor.org.apache.lucene.index.SortedNumericDocValues;
import conductor.org.apache.lucene.search.DocIdSetIterator;
import conductor.org.apache.lucene.search.FieldComparator;
import conductor.org.apache.lucene.search.SortField;
import conductor.org.apache.lucene.util.BitSet;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import conductor.org.elasticsearch.index.fielddata.FieldData;
import conductor.org.elasticsearch.index.fielddata.IndexFieldData;
import conductor.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import conductor.org.elasticsearch.search.MultiValueMode;
import java.io.IOException;

public class LongValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;

    public LongValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.LONG;
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final Long dMissingValue = (Long)this.missingObject(this.missingValue, reversed);
        return new FieldComparator.LongComparator(numHits, null, null){

            @Override
            protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                NumericDocValues selectedValues;
                SortedNumericDocValues values = ((AtomicNumericFieldData)LongValuesComparatorSource.this.indexFieldData.load(context)).getLongValues();
                if (LongValuesComparatorSource.this.nested == null) {
                    selectedValues = FieldData.replaceMissing(LongValuesComparatorSource.this.sortMode.select(values), dMissingValue);
                } else {
                    BitSet rootDocs = LongValuesComparatorSource.this.nested.rootDocs(context);
                    DocIdSetIterator innerDocs = LongValuesComparatorSource.this.nested.innerDocs(context);
                    int maxChildren = LongValuesComparatorSource.this.nested.getNestedSort() != null ? LongValuesComparatorSource.this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
                    selectedValues = LongValuesComparatorSource.this.sortMode.select(values, dMissingValue, rootDocs, innerDocs, context.reader().maxDoc(), maxChildren);
                }
                return selectedValues;
            }
        };
    }
}

