/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.mapper;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.mapper.FieldAliasMapper;
import conductor.org.elasticsearch.index.mapper.FieldMapper;
import conductor.org.elasticsearch.index.mapper.FieldTypeLookup;
import conductor.org.elasticsearch.index.mapper.ObjectMapper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

class MapperMergeValidator {
    MapperMergeValidator() {
    }

    public static void validateMapperStructure(String type, Collection<ObjectMapper> objectMappers, Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers, Map<String, ObjectMapper> fullPathObjectMappers, FieldTypeLookup fieldTypes, boolean updateAllTypes) {
        MapperMergeValidator.checkFieldUniqueness(type, objectMappers, fieldMappers, fieldAliasMappers, fullPathObjectMappers, fieldTypes);
        MapperMergeValidator.checkObjectsCompatibility(objectMappers, fullPathObjectMappers, updateAllTypes);
    }

    private static void checkFieldUniqueness(String type, Collection<ObjectMapper> objectMappers, Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers, Map<String, ObjectMapper> fullPathObjectMappers, FieldTypeLookup fieldTypes) {
        HashSet<String> objectFullNames = new HashSet<String>();
        for (ObjectMapper objectMapper : objectMappers) {
            String fullPath = objectMapper.fullPath();
            if (objectFullNames.add(fullPath)) continue;
            throw new IllegalArgumentException("Object mapper [" + fullPath + "] is defined twice in mapping for type [" + type + "]");
        }
        HashSet fieldNames = new HashSet();
        Stream.concat(fieldMappers.stream(), fieldAliasMappers.stream()).forEach(mapper -> {
            String name = mapper.name();
            if (objectFullNames.contains(name)) {
                throw new IllegalArgumentException("Field [" + name + "] is defined both as an object and a field in [" + type + "]");
            }
            if (!fieldNames.add(name)) {
                throw new IllegalArgumentException("Field [" + name + "] is defined twice in [" + type + "]");
            }
        });
        for (String fieldName : fieldNames) {
            if (!fullPathObjectMappers.containsKey(fieldName)) continue;
            throw new IllegalArgumentException("[" + fieldName + "] is defined as a field in mapping [" + type + "] but this name is already used for an object in other types");
        }
        for (String objectPath : objectFullNames) {
            if (fieldTypes.get(objectPath) == null) continue;
            throw new IllegalArgumentException("[" + objectPath + "] is defined as an object in mapping [" + type + "] but this name is already used for a field in other types");
        }
    }

    private static void checkObjectsCompatibility(Collection<ObjectMapper> objectMappers, Map<String, ObjectMapper> fullPathObjectMappers, boolean updateAllTypes) {
        for (ObjectMapper newObjectMapper : objectMappers) {
            ObjectMapper existingObjectMapper = fullPathObjectMappers.get(newObjectMapper.fullPath());
            if (existingObjectMapper == null) continue;
            existingObjectMapper.merge(newObjectMapper, updateAllTypes);
        }
    }

    public static void validateFieldReferences(IndexSettings indexSettings, List<FieldMapper> fieldMappers, List<FieldAliasMapper> fieldAliasMappers, Map<String, ObjectMapper> fullPathObjectMappers, FieldTypeLookup fieldTypes) {
        if (indexSettings.getIndexVersionCreated().onOrAfter(Version.V_6_0_0_beta1)) {
            MapperMergeValidator.validateCopyTo(fieldMappers, fullPathObjectMappers, fieldTypes);
        }
        MapperMergeValidator.validateFieldAliasTargets(fieldAliasMappers, fullPathObjectMappers);
    }

    private static void validateCopyTo(List<FieldMapper> fieldMappers, Map<String, ObjectMapper> fullPathObjectMappers, FieldTypeLookup fieldTypes) {
        for (FieldMapper mapper : fieldMappers) {
            if (mapper.copyTo() == null || mapper.copyTo().copyToFields().isEmpty()) continue;
            String sourceParent = MapperMergeValidator.parentObject(mapper.name());
            if (sourceParent != null && fieldTypes.get(sourceParent) != null) {
                throw new IllegalArgumentException("[copy_to] may not be used to copy from a multi-field: [" + mapper.name() + "]");
            }
            String sourceScope = MapperMergeValidator.getNestedScope(mapper.name(), fullPathObjectMappers);
            for (String copyTo : mapper.copyTo().copyToFields()) {
                String copyToParent = MapperMergeValidator.parentObject(copyTo);
                if (copyToParent != null && fieldTypes.get(copyToParent) != null) {
                    throw new IllegalArgumentException("[copy_to] may not be used to copy to a multi-field: [" + copyTo + "]");
                }
                if (fullPathObjectMappers.containsKey(copyTo)) {
                    throw new IllegalArgumentException("Cannot copy to field [" + copyTo + "] since it is mapped as an object");
                }
                String targetScope = MapperMergeValidator.getNestedScope(copyTo, fullPathObjectMappers);
                MapperMergeValidator.checkNestedScopeCompatibility(sourceScope, targetScope);
            }
        }
    }

    private static void validateFieldAliasTargets(List<FieldAliasMapper> fieldAliasMappers, Map<String, ObjectMapper> fullPathObjectMappers) {
        for (FieldAliasMapper mapper : fieldAliasMappers) {
            String pathScope;
            String aliasName = mapper.name();
            String path = mapper.path();
            String aliasScope = MapperMergeValidator.getNestedScope(aliasName, fullPathObjectMappers);
            if (Objects.equals(aliasScope, pathScope = MapperMergeValidator.getNestedScope(path, fullPathObjectMappers))) continue;
            StringBuilder message = new StringBuilder("Invalid [path] value [" + path + "] for field alias [" + aliasName + "]: an alias must have the same nested scope as its target. ");
            message.append(aliasScope == null ? "The alias is not nested" : "The alias's nested scope is [" + aliasScope + "]");
            message.append(", but ");
            message.append(pathScope == null ? "the target is not nested." : "the target's nested scope is [" + pathScope + "].");
            throw new IllegalArgumentException(message.toString());
        }
    }

    private static String getNestedScope(String path, Map<String, ObjectMapper> fullPathObjectMappers) {
        String parentPath = MapperMergeValidator.parentObject(path);
        while (parentPath != null) {
            ObjectMapper objectMapper = fullPathObjectMappers.get(parentPath);
            if (objectMapper != null && objectMapper.nested().isNested()) {
                return parentPath;
            }
            parentPath = MapperMergeValidator.parentObject(parentPath);
        }
        return null;
    }

    private static void checkNestedScopeCompatibility(String source, String target) {
        boolean targetIsParentOfSource;
        if (source == null || target == null) {
            targetIsParentOfSource = target == null;
        } else {
            boolean bl = targetIsParentOfSource = source.equals(target) || source.startsWith(target + ".");
        }
        if (!targetIsParentOfSource) {
            throw new IllegalArgumentException("Illegal combination of [copy_to] and [nested] mappings: [copy_to] may only copy data to the current nested document or any of its parents, however one [copy_to] directive is trying to copy data from nested object [" + source + "] to [" + target + "]");
        }
    }

    private static String parentObject(String field) {
        int lastDot = field.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        return field.substring(0, lastDot);
    }
}

