/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.shard;

import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.logging.Loggers;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.shard.IndexShardComponent;
import conductor.org.elasticsearch.index.shard.ShardId;

public abstract class AbstractIndexShardComponent
implements IndexShardComponent {
    protected final Logger logger;
    protected final DeprecationLogger deprecationLogger;
    protected final ShardId shardId;
    protected final IndexSettings indexSettings;

    protected AbstractIndexShardComponent(ShardId shardId, IndexSettings indexSettings) {
        this.shardId = shardId;
        this.indexSettings = indexSettings;
        this.logger = Loggers.getLogger(this.getClass(), shardId, new String[0]);
        this.deprecationLogger = new DeprecationLogger(this.logger);
    }

    @Override
    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public IndexSettings indexSettings() {
        return this.indexSettings;
    }

    public String nodeName() {
        return this.indexSettings.getNodeName();
    }
}

