/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.warmer;

import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.common.metrics.CounterMetric;
import conductor.org.elasticsearch.common.metrics.MeanMetric;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.shard.AbstractIndexShardComponent;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.index.warmer.WarmerStats;
import java.util.concurrent.TimeUnit;

public class ShardIndexWarmerService
extends AbstractIndexShardComponent {
    private final CounterMetric current = new CounterMetric();
    private final MeanMetric warmerMetric = new MeanMetric();

    public ShardIndexWarmerService(ShardId shardId, IndexSettings indexSettings) {
        super(shardId, indexSettings);
    }

    public Logger logger() {
        return this.logger;
    }

    public void onPreWarm() {
        this.current.inc();
    }

    public void onPostWarm(long tookInNanos) {
        this.current.dec();
        this.warmerMetric.inc(tookInNanos);
    }

    public WarmerStats stats() {
        return new WarmerStats(this.current.count(), this.warmerMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.warmerMetric.sum()));
    }
}

