/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.indices.recovery;

import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.ElasticsearchWrapperException;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.unit.ByteSizeValue;
import conductor.org.elasticsearch.index.shard.ShardId;
import java.io.IOException;
import java.util.Objects;

public class RecoverFilesRecoveryException
extends ElasticsearchException
implements ElasticsearchWrapperException {
    private final int numberOfFiles;
    private final ByteSizeValue totalFilesSize;

    public RecoverFilesRecoveryException(ShardId shardId, int numberOfFiles, ByteSizeValue totalFilesSize, Throwable cause) {
        super("Failed to transfer [{}] files with total size of [{}]", cause, numberOfFiles, totalFilesSize);
        Objects.requireNonNull(totalFilesSize, "totalFilesSize must not be null");
        this.setShard(shardId);
        this.numberOfFiles = numberOfFiles;
        this.totalFilesSize = totalFilesSize;
    }

    public int numberOfFiles() {
        return this.numberOfFiles;
    }

    public ByteSizeValue totalFilesSize() {
        return this.totalFilesSize;
    }

    public RecoverFilesRecoveryException(StreamInput in) throws IOException {
        super(in);
        this.numberOfFiles = in.readInt();
        this.totalFilesSize = new ByteSizeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.numberOfFiles);
        this.totalFilesSize.writeTo(out);
    }
}

