/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.protocol.xpack.migration;

import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.action.IndicesRequest;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.action.support.master.MasterNodeReadRequest;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class IndexUpgradeInfoRequest
extends MasterNodeReadRequest<IndexUpgradeInfoRequest>
implements IndicesRequest.Replaceable {
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, true, true, true);

    public IndexUpgradeInfoRequest(String ... indices) {
        this.indices(indices);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndexUpgradeInfoRequest indices(String ... indices) {
        this.indices = Objects.requireNonNull(indices, "indices cannot be null");
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public void indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexUpgradeInfoRequest request = (IndexUpgradeInfoRequest)o;
        return Arrays.equals(this.indices, request.indices) && Objects.equals(this.indicesOptions.toString(), request.indicesOptions.toString());
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), this.indicesOptions.toString());
    }
}

