/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.protocol.xpack.watcher;

import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;

public class DeleteWatchResponse
extends ActionResponse
implements ToXContentObject {
    private static final ObjectParser<DeleteWatchResponse, Void> PARSER = new ObjectParser("x_pack_delete_watch_response", DeleteWatchResponse::new);
    private String id;
    private long version;
    private boolean found;

    public DeleteWatchResponse() {
    }

    public DeleteWatchResponse(String id, long version, boolean found) {
        this.id = id;
        this.version = version;
        this.found = found;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean isFound() {
        return this.found;
    }

    private void setId(String id) {
        this.id = id;
    }

    private void setVersion(long version) {
        this.version = version;
    }

    private void setFound(boolean found) {
        this.found = found;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteWatchResponse that = (DeleteWatchResponse)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version) && Objects.equals(this.found, that.found);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.found);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readString();
        this.version = in.readVLong();
        this.found = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeVLong(this.version);
        out.writeBoolean(this.found);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("_id", this.id).field("_version", this.version).field("found", this.found).endObject();
    }

    public static DeleteWatchResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    static {
        PARSER.declareString(DeleteWatchResponse::setId, new ParseField("_id", new String[0]));
        PARSER.declareLong(DeleteWatchResponse::setVersion, new ParseField("_version", new String[0]));
        PARSER.declareBoolean(DeleteWatchResponse::setFound, new ParseField("found", new String[0]));
    }
}

