/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.admin.cluster;

import conductor.org.elasticsearch.action.admin.cluster.remote.RemoteInfoAction;
import conductor.org.elasticsearch.action.admin.cluster.remote.RemoteInfoRequest;
import conductor.org.elasticsearch.action.admin.cluster.remote.RemoteInfoResponse;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.BytesRestResponse;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.RestResponse;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.rest.action.RestBuilderListener;
import java.io.IOException;

public final class RestRemoteClusterInfoAction
extends BaseRestHandler {
    public RestRemoteClusterInfoAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "_remote/info", this);
    }

    @Override
    public String getName() {
        return "remote_cluster_info_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return channel -> client.execute(RemoteInfoAction.INSTANCE, new RemoteInfoRequest(), new RestBuilderListener<RemoteInfoResponse>(channel){

            @Override
            public RestResponse buildResponse(RemoteInfoResponse response, XContentBuilder builder) throws Exception {
                response.toXContent(builder, request);
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

