/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.script.mustache;

import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.RestToXContentListener;
import conductor.org.elasticsearch.script.ScriptType;
import conductor.org.elasticsearch.script.mustache.SearchTemplateAction;
import conductor.org.elasticsearch.script.mustache.SearchTemplateRequest;
import java.io.IOException;

public class RestRenderSearchTemplateAction
extends BaseRestHandler {
    public RestRenderSearchTemplateAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_render/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/_render/template", this);
        controller.registerHandler(RestRequest.Method.GET, "/_render/template/{id}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_render/template/{id}", this);
    }

    @Override
    public String getName() {
        return "render_search_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchTemplateRequest renderRequest;
        try (XContentParser parser = request.contentOrSourceParamParser();){
            renderRequest = SearchTemplateRequest.fromXContent(parser);
        }
        renderRequest.setSimulate(true);
        String id = request.param("id");
        if (id != null) {
            renderRequest.setScriptType(ScriptType.STORED);
            renderRequest.setScript(id);
        }
        return channel -> client.execute(SearchTemplateAction.INSTANCE, renderRequest, new RestToXContentListener((RestChannel)channel));
    }
}

