/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.adjacency;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.search.aggregations.Aggregation;
import conductor.org.elasticsearch.search.aggregations.Aggregations;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.InternalAggregations;
import conductor.org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import conductor.org.elasticsearch.search.aggregations.bucket.adjacency.AdjacencyMatrix;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InternalAdjacencyMatrix
extends InternalMultiBucketAggregation<InternalAdjacencyMatrix, InternalBucket>
implements AdjacencyMatrix {
    private final List<InternalBucket> buckets;
    private Map<String, InternalBucket> bucketMap;

    public InternalAdjacencyMatrix(String name, List<InternalBucket> buckets, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.buckets = buckets;
    }

    public InternalAdjacencyMatrix(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        ArrayList<InternalBucket> buckets = new ArrayList<InternalBucket>(size);
        for (int i = 0; i < size; ++i) {
            buckets.add(new InternalBucket(in));
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.buckets.size());
        for (InternalBucket bucket : this.buckets) {
            bucket.writeTo(out);
        }
    }

    @Override
    public String getWriteableName() {
        return "adjacency_matrix";
    }

    @Override
    public InternalAdjacencyMatrix create(List<InternalBucket> buckets) {
        return new InternalAdjacencyMatrix(this.name, buckets, this.pipelineAggregators(), this.metaData);
    }

    @Override
    public InternalBucket createBucket(InternalAggregations aggregations, InternalBucket prototype) {
        return new InternalBucket(prototype.key, prototype.docCount, aggregations);
    }

    @Override
    public List<InternalBucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public InternalBucket getBucketByKey(String key) {
        if (this.bucketMap == null) {
            this.bucketMap = new HashMap<String, InternalBucket>(this.buckets.size());
            for (InternalBucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKey(), bucket);
            }
        }
        return this.bucketMap.get(key);
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        HashMap<String, ArrayList<InternalBucket>> bucketsMap = new HashMap<String, ArrayList<InternalBucket>>();
        for (InternalAggregation internalAggregation : aggregations) {
            InternalAdjacencyMatrix filters = (InternalAdjacencyMatrix)internalAggregation;
            for (InternalBucket bucket : filters.buckets) {
                ArrayList<InternalBucket> sameRangeList = (ArrayList<InternalBucket>)bucketsMap.get(bucket.key);
                if (sameRangeList == null) {
                    sameRangeList = new ArrayList<InternalBucket>(aggregations.size());
                    bucketsMap.put(bucket.key, sameRangeList);
                }
                sameRangeList.add(bucket);
            }
        }
        ArrayList<InternalBucket> reducedBuckets = new ArrayList<InternalBucket>(bucketsMap.size());
        for (List sameRangeList : bucketsMap.values()) {
            InternalBucket reducedBucket = ((InternalBucket)sameRangeList.get(0)).reduce(sameRangeList, reduceContext);
            if (reducedBucket.docCount >= 1L) {
                reduceContext.consumeBucketsAndMaybeBreak(1);
                reducedBuckets.add(reducedBucket);
                continue;
            }
            reduceContext.consumeBucketsAndMaybeBreak(-InternalAdjacencyMatrix.countInnerBucket(reducedBucket));
        }
        Collections.sort(reducedBuckets, Comparator.comparing(InternalBucket::getKey));
        InternalAdjacencyMatrix internalAdjacencyMatrix = new InternalAdjacencyMatrix(this.name, reducedBuckets, this.pipelineAggregators(), this.getMetaData());
        return internalAdjacencyMatrix;
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (InternalBucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.buckets);
    }

    @Override
    protected boolean doEquals(Object obj) {
        InternalAdjacencyMatrix that = (InternalAdjacencyMatrix)obj;
        return Objects.equals(this.buckets, that.buckets);
    }

    public static class InternalBucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements AdjacencyMatrix.Bucket {
        private final String key;
        private long docCount;
        InternalAggregations aggregations;

        public InternalBucket(String key, long docCount, InternalAggregations aggregations) {
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        public InternalBucket(StreamInput in) throws IOException {
            this.key = in.readOptionalString();
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readAggregations(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.key);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            return this.key;
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        InternalBucket reduce(List<InternalBucket> buckets, InternalAggregation.ReduceContext context) {
            InternalBucket reduced = null;
            ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
            for (InternalBucket bucket : buckets) {
                if (reduced == null) {
                    reduced = new InternalBucket(bucket.key, bucket.docCount, bucket.aggregations);
                } else {
                    reduced.docCount += bucket.docCount;
                }
                aggregationsList.add(bucket.aggregations);
            }
            reduced.aggregations = InternalAggregations.reduce(aggregationsList, context);
            return reduced;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            InternalBucket that = (InternalBucket)other;
            return Objects.equals(this.key, that.key) && Objects.equals(this.docCount, that.docCount) && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.key, this.docCount, this.aggregations);
        }
    }
}

