/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.sampler;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.lease.Releasables;
import conductor.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import conductor.org.elasticsearch.search.aggregations.AggregationExecutionException;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollector;
import conductor.org.elasticsearch.search.aggregations.bucket.DeferableBucketAggregator;
import conductor.org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import conductor.org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import conductor.org.elasticsearch.search.aggregations.bucket.sampler.BestDocsDeferringCollector;
import conductor.org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedBytesHashSamplerAggregator;
import conductor.org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedMapSamplerAggregator;
import conductor.org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedOrdinalsSamplerAggregator;
import conductor.org.elasticsearch.search.aggregations.bucket.sampler.InternalSampler;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class SamplerAggregator
extends DeferableBucketAggregator
implements SingleBucketAggregator {
    public static final ParseField SHARD_SIZE_FIELD = new ParseField("shard_size", new String[0]);
    public static final ParseField MAX_DOCS_PER_VALUE_FIELD = new ParseField("max_docs_per_value", new String[0]);
    public static final ParseField EXECUTION_HINT_FIELD = new ParseField("execution_hint", new String[0]);
    protected final int shardSize;
    protected BestDocsDeferringCollector bdd;

    SamplerAggregator(String name, int shardSize, AggregatorFactories factories, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
        this.shardSize = shardSize;
    }

    @Override
    public boolean needsScores() {
        return true;
    }

    @Override
    public DeferringBucketCollector getDeferringCollector() {
        this.bdd = new BestDocsDeferringCollector(this.shardSize, this.context.bigArrays());
        return this.bdd;
    }

    @Override
    protected boolean shouldDefer(Aggregator aggregator) {
        return true;
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        this.runDeferredCollections(owningBucketOrdinal);
        return new InternalSampler(this.name, this.bdd == null ? 0L : (long)this.bdd.getDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalSampler(this.name, 0L, this.buildEmptySubAggregations(), this.pipelineAggregators(), this.metaData());
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.bdd == null) {
            throw new AggregationExecutionException("Sampler aggregation must be used with child aggregations.");
        }
        return this.bdd.getLeafCollector(ctx);
    }

    @Override
    protected void doClose() {
        Releasables.close(this.bdd);
        super.doClose();
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, int shardSize, int maxDocsPerValue, ValuesSource valuesSource, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                return new DiversifiedMapSamplerAggregator(name, shardSize, factories, context, parent, pipelineAggregators, metaData, valuesSource, maxDocsPerValue);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return false;
            }
        }
        ,
        BYTES_HASH(new ParseField("bytes_hash", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, int shardSize, int maxDocsPerValue, ValuesSource valuesSource, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                return new DiversifiedBytesHashSamplerAggregator(name, shardSize, factories, context, parent, pipelineAggregators, metaData, valuesSource, maxDocsPerValue);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return false;
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, int shardSize, int maxDocsPerValue, ValuesSource valuesSource, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                return new DiversifiedOrdinalsSamplerAggregator(name, shardSize, factories, context, parent, pipelineAggregators, metaData, (ValuesSource.Bytes.WithOrdinals.FieldData)valuesSource, maxDocsPerValue);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return true;
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value) {
            for (ExecutionMode mode : ExecutionMode.values()) {
                if (!mode.parseField.match(value, LoggingDeprecationHandler.INSTANCE)) continue;
                return mode;
            }
            throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of " + Arrays.toString((Object[])ExecutionMode.values()));
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, int var3, int var4, ValuesSource var5, SearchContext var6, Aggregator var7, List<PipelineAggregator> var8, Map<String, Object> var9) throws IOException;

        abstract boolean needsGlobalOrdinals();

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

