/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.metrics.max;

import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.search.aggregations.Aggregation;
import conductor.org.elasticsearch.search.aggregations.metrics.ParsedSingleValueNumericMetricsAggregation;
import conductor.org.elasticsearch.search.aggregations.metrics.max.Max;
import java.io.IOException;

public class ParsedMax
extends ParsedSingleValueNumericMetricsAggregation
implements Max {
    private static final ObjectParser<ParsedMax, Void> PARSER = new ObjectParser(ParsedMax.class.getSimpleName(), true, ParsedMax::new);

    @Override
    public double getValue() {
        return this.value();
    }

    @Override
    public String getType() {
        return "max";
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = !Double.isInfinite(this.value);
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), hasValue ? Double.valueOf(this.value) : null);
        if (hasValue && this.valueAsString != null) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.valueAsString);
        }
        return builder;
    }

    public static ParsedMax fromXContent(XContentParser parser, String name) {
        ParsedMax max = PARSER.apply(parser, null);
        max.setName(name);
        return max;
    }

    static {
        ParsedMax.declareSingleValueFields(PARSER, Double.NEGATIVE_INFINITY);
    }
}

