/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.pipeline.movavg.models;

import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.search.aggregations.pipeline.movavg.MovAvgPipelineAggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModel;
import conductor.org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModelBuilder;
import conductor.org.elasticsearch.search.aggregations.pipeline.movfn.MovingFunctions;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class LinearModel
extends MovAvgModel {
    public static final String NAME = "linear";
    public static final MovAvgModel.AbstractModelParser PARSER = new MovAvgModel.AbstractModelParser(){

        @Override
        public MovAvgModel parse(@Nullable Map<String, Object> settings, String pipelineName, int windowSize) throws ParseException {
            this.checkUnrecognizedParams(settings);
            return new LinearModel();
        }
    };

    public LinearModel() {
    }

    public LinearModel(StreamInput in) {
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean canBeMinimized() {
        return false;
    }

    @Override
    public MovAvgModel neighboringModel() {
        return new LinearModel();
    }

    @Override
    public MovAvgModel clone() {
        return new LinearModel();
    }

    @Override
    protected double[] doPredict(Collection<Double> values, int numPredictions) {
        double[] predictions = new double[numPredictions];
        Arrays.fill(predictions, this.next(values));
        return predictions;
    }

    @Override
    public double next(Collection<Double> values) {
        return MovingFunctions.linearWeightedAvg(values.stream().mapToDouble(Double::doubleValue).toArray());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(MovAvgPipelineAggregationBuilder.MODEL.getPreferredName(), NAME);
        return builder;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public static class LinearModelBuilder
    implements MovAvgModelBuilder {
        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(MovAvgPipelineAggregationBuilder.MODEL.getPreferredName(), LinearModel.NAME);
            return builder;
        }

        @Override
        public MovAvgModel build() {
            return new LinearModel();
        }
    }
}

