/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.fetch;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.elasticsearch.search.SearchHit;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public interface FetchSubPhase {
    default public void hitExecute(SearchContext context, HitContext hitContext) throws IOException {
    }

    default public void hitsExecute(SearchContext context, SearchHit[] hits) throws IOException {
    }

    public static class HitContext {
        private SearchHit hit;
        private IndexSearcher searcher;
        private LeafReaderContext readerContext;
        private int docId;
        private Map<String, Object> cache;

        public void reset(SearchHit hit, LeafReaderContext context, int docId, IndexSearcher searcher) {
            this.hit = hit;
            this.readerContext = context;
            this.docId = docId;
            this.searcher = searcher;
        }

        public SearchHit hit() {
            return this.hit;
        }

        public LeafReader reader() {
            return this.readerContext.reader();
        }

        public LeafReaderContext readerContext() {
            return this.readerContext;
        }

        public int docId() {
            return this.docId;
        }

        public IndexReader topLevelReader() {
            return this.searcher.getIndexReader();
        }

        public Map<String, Object> cache() {
            if (this.cache == null) {
                this.cache = new HashMap<String, Object>();
            }
            return this.cache;
        }
    }
}

