/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.fetch.subphase.highlight;

import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.search.highlight.DefaultEncoder;
import conductor.org.apache.lucene.search.highlight.Encoder;
import conductor.org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import conductor.org.elasticsearch.index.fieldvisitor.CustomFieldsVisitor;
import conductor.org.elasticsearch.index.mapper.DocumentMapper;
import conductor.org.elasticsearch.index.mapper.KeywordFieldMapper;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.search.fetch.FetchSubPhase;
import conductor.org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import conductor.org.elasticsearch.search.internal.SearchContext;
import conductor.org.elasticsearch.search.lookup.SourceLookup;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class HighlightUtils {
    public static final char PARAGRAPH_SEPARATOR = '\u2029';
    public static final char NULL_SEPARATOR = '\u0000';

    private HighlightUtils() {
    }

    public static List<Object> loadFieldValues(SearchContextHighlight.Field field, MappedFieldType fieldType, SearchContext searchContext, FetchSubPhase.HitContext hitContext) throws IOException {
        List<Object> textsToHighlight;
        boolean forceSource = searchContext.highlight().forceSource(field);
        if (!forceSource && fieldType.stored()) {
            CustomFieldsVisitor fieldVisitor = new CustomFieldsVisitor(Collections.singleton(fieldType.name()), false);
            hitContext.reader().document(hitContext.docId(), fieldVisitor);
            textsToHighlight = fieldVisitor.fields().get(fieldType.name());
            if (textsToHighlight == null) {
                textsToHighlight = Collections.emptyList();
            }
        } else {
            SourceLookup sourceLookup = searchContext.lookup().source();
            sourceLookup.setSegmentAndDocument(hitContext.readerContext(), hitContext.docId());
            textsToHighlight = sourceLookup.extractRawValues(fieldType.name());
        }
        assert (textsToHighlight != null);
        return textsToHighlight;
    }

    static Analyzer getAnalyzer(DocumentMapper docMapper, MappedFieldType type) {
        KeywordFieldMapper.KeywordFieldType keywordFieldType;
        if (type instanceof KeywordFieldMapper.KeywordFieldType && (keywordFieldType = (KeywordFieldMapper.KeywordFieldType)type).normalizer() != null) {
            return keywordFieldType.normalizer();
        }
        return docMapper.mappers().indexAnalyzer();
    }

    public static class Encoders {
        public static final Encoder DEFAULT = new DefaultEncoder();
        public static final Encoder HTML = new SimpleHTMLEncoder();
    }
}

