/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.internal;

import conductor.org.elasticsearch.action.search.SearchResponseSections;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.search.SearchHits;
import conductor.org.elasticsearch.search.aggregations.InternalAggregations;
import conductor.org.elasticsearch.search.profile.SearchProfileShardResults;
import conductor.org.elasticsearch.search.suggest.Suggest;
import java.io.IOException;

public class InternalSearchResponse
extends SearchResponseSections
implements Writeable,
ToXContentFragment {
    public static InternalSearchResponse empty() {
        return new InternalSearchResponse(SearchHits.empty(), null, null, null, false, null, 1);
    }

    public InternalSearchResponse(SearchHits hits, InternalAggregations aggregations, Suggest suggest, SearchProfileShardResults profileResults, boolean timedOut, Boolean terminatedEarly, int numReducePhases) {
        super(hits, aggregations, suggest, timedOut, terminatedEarly, profileResults, numReducePhases);
    }

    public InternalSearchResponse(StreamInput in) throws IOException {
        super(SearchHits.readSearchHits(in), in.readBoolean() ? InternalAggregations.readAggregations(in) : null, in.readBoolean() ? Suggest.readSuggest(in) : null, in.readBoolean(), in.readOptionalBoolean(), in.readOptionalWriteable(SearchProfileShardResults::new), in.readVInt());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.hits.writeTo(out);
        out.writeOptionalStreamable((InternalAggregations)this.aggregations);
        out.writeOptionalStreamable(this.suggest);
        out.writeBoolean(this.timedOut);
        out.writeOptionalBoolean(this.terminatedEarly);
        out.writeOptionalWriteable(this.profileResults);
        out.writeVInt(this.numReducePhases);
    }
}

