/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.query;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.CollectionTerminatedException;
import conductor.org.apache.lucene.search.Collector;
import conductor.org.apache.lucene.search.FilterCollector;
import conductor.org.apache.lucene.search.FilterLeafCollector;
import conductor.org.apache.lucene.search.LeafCollector;
import java.io.IOException;

public class EarlyTerminatingCollector
extends FilterCollector {
    private final int maxCountHits;
    private int numCollected;
    private boolean forceTermination;

    EarlyTerminatingCollector(Collector delegate, int maxCountHits, boolean forceTermination) {
        super(delegate);
        this.maxCountHits = maxCountHits;
        this.forceTermination = forceTermination;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        if (this.numCollected >= this.maxCountHits) {
            if (this.forceTermination) {
                throw new EarlyTerminationException("early termination [CountBased]");
            }
            throw new CollectionTerminatedException();
        }
        return new FilterLeafCollector(super.getLeafCollector(context)){

            @Override
            public void collect(int doc) throws IOException {
                if (++EarlyTerminatingCollector.this.numCollected > EarlyTerminatingCollector.this.maxCountHits) {
                    if (EarlyTerminatingCollector.this.forceTermination) {
                        throw new EarlyTerminationException("early termination [CountBased]");
                    }
                    throw new CollectionTerminatedException();
                }
                super.collect(doc);
            }
        };
    }

    static final class EarlyTerminationException
    extends RuntimeException {
        EarlyTerminationException(String msg) {
            super(msg);
        }
    }
}

