/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.elasticsearch.query.parser;

import com.netflix.conductor.elasticsearch.query.parser.FunctionThrowingException;
import com.netflix.conductor.elasticsearch.query.parser.ParserException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class AbstractNode {
    public static final Pattern WHITESPACE = Pattern.compile("\\s");
    protected static Set<Character> comparisonOprs = new HashSet<Character>();
    protected InputStream is;

    protected AbstractNode(InputStream is) throws ParserException {
        this.is = is;
        this.parse();
    }

    protected boolean isNumber(String test) {
        try {
            new BigDecimal(test);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected boolean isBoolOpr(byte[] buffer) {
        if (buffer.length > 1 && buffer[0] == 79 && buffer[1] == 82) {
            return true;
        }
        return buffer.length > 2 && buffer[0] == 65 && buffer[1] == 78 && buffer[2] == 68;
    }

    protected boolean isComparisonOpr(byte[] buffer) {
        if (buffer[0] == 73 && buffer[1] == 78) {
            return true;
        }
        if (buffer[0] == 33 && buffer[1] == 61) {
            return true;
        }
        return comparisonOprs.contains(Character.valueOf((char)buffer[0]));
    }

    protected byte[] peek(int length) throws Exception {
        return this.read(length, true);
    }

    protected byte[] read(int length) throws Exception {
        return this.read(length, false);
    }

    protected String readToken() throws Exception {
        this.skipWhitespace();
        StringBuilder sb = new StringBuilder();
        while (this.is.available() > 0) {
            char c = (char)this.peek(1)[0];
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                this.is.skip(1L);
                break;
            }
            if (c == '=' || c == '>' || c == '<' || c == '!') break;
            sb.append(c);
            this.is.skip(1L);
        }
        return sb.toString().trim();
    }

    protected boolean isNumeric(char c) {
        return c == '-' || c == 'e' || c >= '0' && c <= '9' || c == '.';
    }

    protected void assertExpected(byte[] found, String expected) throws ParserException {
        this.assertExpected(new String(found), expected);
    }

    protected void assertExpected(String found, String expected) throws ParserException {
        if (!found.equals(expected)) {
            throw new ParserException("Expected " + expected + ", found " + found);
        }
    }

    protected void assertExpected(char found, char expected) throws ParserException {
        if (found != expected) {
            throw new ParserException("Expected " + expected + ", found " + found);
        }
    }

    protected static void efor(int length, FunctionThrowingException<Integer> consumer) throws Exception {
        for (int i = 0; i < length; ++i) {
            consumer.accept(i);
        }
    }

    protected abstract void _parse() throws Exception;

    private void parse() throws ParserException {
        this.skipWhitespace();
        try {
            this._parse();
        }
        catch (Exception e) {
            System.out.println("\t" + this.getClass().getSimpleName() + "->" + this.toString());
            if (!(e instanceof ParserException)) {
                throw new ParserException("Error parsing", e);
            }
            throw (ParserException)e;
        }
        this.skipWhitespace();
    }

    private byte[] read(int length, boolean peekOnly) throws Exception {
        byte[] buf = new byte[length];
        if (peekOnly) {
            this.is.mark(length);
        }
        AbstractNode.efor(length, c -> {
            buf[c.intValue()] = (byte)this.is.read();
        });
        if (peekOnly) {
            this.is.reset();
        }
        return buf;
    }

    protected void skipWhitespace() throws ParserException {
        try {
            byte c;
            while (this.is.available() > 0 && ((c = this.peek(1)[0]) == 32 || c == 9 || c == 10 || c == 13)) {
                this.read(1);
            }
        }
        catch (Exception e) {
            throw new ParserException(e.getMessage(), e);
        }
    }

    static {
        comparisonOprs.add(Character.valueOf('>'));
        comparisonOprs.add(Character.valueOf('<'));
        comparisonOprs.add(Character.valueOf('='));
    }
}

