/*
 * Decompiled with CFR 0.152.
 */
package conductor.com.carrotsearch.hppc;

import conductor.com.carrotsearch.hppc.BitMixer;
import conductor.com.carrotsearch.hppc.CharDoubleHashMap;
import conductor.com.carrotsearch.hppc.HashOrderMixing;

public class CharDoubleScatterMap
extends CharDoubleHashMap {
    public CharDoubleScatterMap() {
        this(4);
    }

    public CharDoubleScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharDoubleScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(char key) {
        return BitMixer.mixPhi(key);
    }

    public static CharDoubleScatterMap from(char[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharDoubleScatterMap map = new CharDoubleScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

