/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.Collector;
import conductor.org.apache.lucene.search.DocValuesStats;
import conductor.org.apache.lucene.search.LeafCollector;
import conductor.org.apache.lucene.search.Scorer;
import java.io.IOException;

public class DocValuesStatsCollector
implements Collector {
    private final DocValuesStats<?> stats;

    public DocValuesStatsCollector(DocValuesStats<?> stats) {
        this.stats = stats;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        boolean shouldProcess = this.stats.init(context);
        if (!shouldProcess) {
            return new LeafCollector(){

                @Override
                public void setScorer(Scorer scorer) throws IOException {
                }

                @Override
                public void collect(int doc) throws IOException {
                    DocValuesStatsCollector.this.stats.addMissing();
                }
            };
        }
        return new LeafCollector(){

            @Override
            public void setScorer(Scorer scorer) throws IOException {
            }

            @Override
            public void collect(int doc) throws IOException {
                DocValuesStatsCollector.this.stats.accumulate(doc);
            }
        };
    }

    @Override
    public boolean needsScores() {
        return false;
    }
}

