/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.bulk;

import conductor.org.elasticsearch.action.ActionRequest;
import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.action.CompositeIndicesRequest;
import conductor.org.elasticsearch.action.DocWriteRequest;
import conductor.org.elasticsearch.action.ValidateActions;
import conductor.org.elasticsearch.action.bulk.BulkShardRequest;
import conductor.org.elasticsearch.action.delete.DeleteRequest;
import conductor.org.elasticsearch.action.index.IndexRequest;
import conductor.org.elasticsearch.action.support.ActiveShardCount;
import conductor.org.elasticsearch.action.support.WriteRequest;
import conductor.org.elasticsearch.action.update.UpdateRequest;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.bytes.BytesArray;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.logging.Loggers;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.xcontent.DeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.common.xcontent.XContent;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import conductor.org.elasticsearch.index.VersionType;
import conductor.org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class BulkRequest
extends ActionRequest
implements CompositeIndicesRequest,
WriteRequest<BulkRequest> {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(BulkRequest.class));
    private static final int REQUEST_OVERHEAD = 50;
    private static final ParseField INDEX = new ParseField("_index", new String[0]);
    private static final ParseField TYPE = new ParseField("_type", new String[0]);
    private static final ParseField ID = new ParseField("_id", new String[0]);
    private static final ParseField ROUTING = new ParseField("routing", "_routing");
    private static final ParseField PARENT = new ParseField("parent", "_parent");
    private static final ParseField OP_TYPE = new ParseField("op_type", "opType");
    private static final ParseField VERSION = new ParseField("version", "_version");
    private static final ParseField VERSION_TYPE = new ParseField("version_type", "_version_type", "_versionType", "versionType");
    private static final ParseField RETRY_ON_CONFLICT = new ParseField("retry_on_conflict", "_retry_on_conflict", "_retryOnConflict");
    private static final ParseField PIPELINE = new ParseField("pipeline", new String[0]);
    private static final ParseField FIELDS = new ParseField("fields", new String[0]);
    private static final ParseField SOURCE = new ParseField("_source", new String[0]);
    final List<DocWriteRequest<?>> requests = new ArrayList();
    private final Set<String> indices = new HashSet<String>();
    List<Object> payloads = null;
    protected TimeValue timeout = BulkShardRequest.DEFAULT_TIMEOUT;
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.NONE;
    private long sizeInBytes = 0L;

    public BulkRequest add(DocWriteRequest<?> ... requests) {
        for (DocWriteRequest<?> request : requests) {
            this.add(request, (Object)null);
        }
        return this;
    }

    public BulkRequest add(DocWriteRequest<?> request) {
        return this.add(request, (Object)null);
    }

    public BulkRequest add(DocWriteRequest<?> request, @Nullable Object payload) {
        if (request instanceof IndexRequest) {
            this.add((IndexRequest)request, payload);
        } else if (request instanceof DeleteRequest) {
            this.add((DeleteRequest)request, payload);
        } else if (request instanceof UpdateRequest) {
            this.add((UpdateRequest)request, payload);
        } else {
            throw new IllegalArgumentException("No support for request [" + request + "]");
        }
        this.indices.add(request.index());
        return this;
    }

    public BulkRequest add(Iterable<DocWriteRequest<?>> requests) {
        for (DocWriteRequest<?> request : requests) {
            this.add(request);
        }
        return this;
    }

    public BulkRequest add(IndexRequest request) {
        return this.internalAdd(request, null);
    }

    public BulkRequest add(IndexRequest request, @Nullable Object payload) {
        return this.internalAdd(request, payload);
    }

    BulkRequest internalAdd(IndexRequest request, @Nullable Object payload) {
        Objects.requireNonNull(request, "'request' must not be null");
        this.requests.add(request);
        this.addPayload(payload);
        this.sizeInBytes += (long)((request.source() != null ? request.source().length() : 0) + 50);
        this.indices.add(request.index());
        return this;
    }

    public BulkRequest add(UpdateRequest request) {
        return this.internalAdd(request, null);
    }

    public BulkRequest add(UpdateRequest request, @Nullable Object payload) {
        return this.internalAdd(request, payload);
    }

    BulkRequest internalAdd(UpdateRequest request, @Nullable Object payload) {
        Objects.requireNonNull(request, "'request' must not be null");
        this.requests.add(request);
        this.addPayload(payload);
        if (request.doc() != null) {
            this.sizeInBytes += (long)request.doc().source().length();
        }
        if (request.upsertRequest() != null) {
            this.sizeInBytes += (long)request.upsertRequest().source().length();
        }
        if (request.script() != null) {
            this.sizeInBytes += (long)(request.script().getIdOrCode().length() * 2);
        }
        this.indices.add(request.index());
        return this;
    }

    public BulkRequest add(DeleteRequest request) {
        return this.add(request, (Object)null);
    }

    public BulkRequest add(DeleteRequest request, @Nullable Object payload) {
        Objects.requireNonNull(request, "'request' must not be null");
        this.requests.add(request);
        this.addPayload(payload);
        this.sizeInBytes += 50L;
        this.indices.add(request.index());
        return this;
    }

    private void addPayload(Object payload) {
        if (this.payloads == null) {
            if (payload == null) {
                return;
            }
            this.payloads = new ArrayList<Object>(this.requests.size() + 10);
            for (int i = 1; i < this.requests.size(); ++i) {
                this.payloads.add(null);
            }
        }
        this.payloads.add(payload);
    }

    public List<DocWriteRequest<?>> requests() {
        return this.requests;
    }

    @Nullable
    public List<Object> payloads() {
        return this.payloads;
    }

    public int numberOfActions() {
        return this.requests.size();
    }

    public long estimatedSizeInBytes() {
        return this.sizeInBytes;
    }

    public BulkRequest add(byte[] data, int from, int length, XContentType xContentType) throws IOException {
        return this.add(data, from, length, null, null, xContentType);
    }

    public BulkRequest add(byte[] data, int from, int length, @Nullable String defaultIndex, @Nullable String defaultType, XContentType xContentType) throws IOException {
        return this.add(new BytesArray(data, from, length), defaultIndex, defaultType, xContentType);
    }

    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, XContentType xContentType) throws IOException {
        return this.add(data, defaultIndex, defaultType, null, null, null, null, null, true, xContentType);
    }

    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, boolean allowExplicitIndex, XContentType xContentType) throws IOException {
        return this.add(data, defaultIndex, defaultType, null, null, null, null, null, allowExplicitIndex, xContentType);
    }

    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, @Nullable String defaultRouting, @Nullable String[] defaultFields, @Nullable FetchSourceContext defaultFetchSourceContext, @Nullable String defaultPipeline, @Nullable Object payload, boolean allowExplicitIndex, XContentType xContentType) throws IOException {
        int nextMarker;
        XContent xContent = xContentType.xContent();
        int line = 0;
        int from = 0;
        int length = data.length();
        byte marker = xContent.streamSeparator();
        while ((nextMarker = this.findNextMarker(marker, from, data, length)) != -1) {
            ++line;
            StreamInput stream = data.slice(from, nextMarker - from).streamInput();
            try {
                XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, stream);
                try {
                    from = nextMarker + 1;
                    XContentParser.Token token = parser.nextToken();
                    if (token == null) continue;
                    if (token != XContentParser.Token.START_OBJECT) {
                        throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected " + (Object)((Object)XContentParser.Token.START_OBJECT) + " but found [" + (Object)((Object)token) + "]");
                    }
                    token = parser.nextToken();
                    if (token != XContentParser.Token.FIELD_NAME) {
                        throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected " + (Object)((Object)XContentParser.Token.FIELD_NAME) + " but found [" + (Object)((Object)token) + "]");
                    }
                    String action = parser.currentName();
                    String index = defaultIndex;
                    String type = defaultType;
                    String id = null;
                    String routing = defaultRouting;
                    String parent = null;
                    FetchSourceContext fetchSourceContext = defaultFetchSourceContext;
                    String[] fields = defaultFields;
                    String opType = null;
                    long version = -3L;
                    VersionType versionType = VersionType.INTERNAL;
                    int retryOnConflict = 0;
                    String pipeline = defaultPipeline;
                    token = parser.nextToken();
                    if (token == XContentParser.Token.START_OBJECT) {
                        String currentFieldName = null;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token.isValue()) {
                                if (INDEX.match(currentFieldName, parser.getDeprecationHandler())) {
                                    if (!allowExplicitIndex) {
                                        throw new IllegalArgumentException("explicit index in bulk is not allowed");
                                    }
                                    index = parser.text();
                                    continue;
                                }
                                if (TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                                    type = parser.text();
                                    continue;
                                }
                                if (ID.match(currentFieldName, parser.getDeprecationHandler())) {
                                    id = parser.text();
                                    continue;
                                }
                                if (ROUTING.match(currentFieldName, parser.getDeprecationHandler())) {
                                    routing = parser.text();
                                    continue;
                                }
                                if (PARENT.match(currentFieldName, parser.getDeprecationHandler())) {
                                    parent = parser.text();
                                    continue;
                                }
                                if (OP_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                                    opType = parser.text();
                                    continue;
                                }
                                if (VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                                    version = parser.longValue();
                                    continue;
                                }
                                if (VERSION_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                                    versionType = VersionType.fromString(parser.text());
                                    continue;
                                }
                                if (RETRY_ON_CONFLICT.match(currentFieldName, parser.getDeprecationHandler())) {
                                    retryOnConflict = parser.intValue();
                                    continue;
                                }
                                if (PIPELINE.match(currentFieldName, parser.getDeprecationHandler())) {
                                    pipeline = parser.text();
                                    continue;
                                }
                                if (FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                                    throw new IllegalArgumentException("Action/metadata line [" + line + "] contains a simple value for parameter [fields] while a list is expected");
                                }
                                if (SOURCE.match(currentFieldName, parser.getDeprecationHandler())) {
                                    fetchSourceContext = FetchSourceContext.fromXContent(parser);
                                    continue;
                                }
                                throw new IllegalArgumentException("Action/metadata line [" + line + "] contains an unknown parameter [" + currentFieldName + "]");
                            }
                            if (token == XContentParser.Token.START_ARRAY) {
                                if (FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                                    DEPRECATION_LOGGER.deprecated("Deprecated field [fields] used, expected [_source] instead", new Object[0]);
                                    List<Object> values = parser.list();
                                    fields = values.toArray(new String[values.size()]);
                                    continue;
                                }
                                throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected a simple value for field [" + currentFieldName + "] but found [" + (Object)((Object)token) + "]");
                            }
                            if (token == XContentParser.Token.START_OBJECT && SOURCE.match(currentFieldName, parser.getDeprecationHandler())) {
                                fetchSourceContext = FetchSourceContext.fromXContent(parser);
                                continue;
                            }
                            if (token == XContentParser.Token.VALUE_NULL) continue;
                            throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected a simple value for field [" + currentFieldName + "] but found [" + (Object)((Object)token) + "]");
                        }
                    } else if (token != XContentParser.Token.END_OBJECT) {
                        throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected " + (Object)((Object)XContentParser.Token.START_OBJECT) + " or " + (Object)((Object)XContentParser.Token.END_OBJECT) + " but found [" + (Object)((Object)token) + "]");
                    }
                    if ("delete".equals(action)) {
                        this.add(new DeleteRequest(index, type, id).routing(routing).parent(parent).version(version).versionType(versionType), payload);
                        continue;
                    }
                    nextMarker = this.findNextMarker(marker, from, data, length);
                    if (nextMarker == -1) break;
                    ++line;
                    if ("index".equals(action)) {
                        if (opType == null) {
                            this.internalAdd(new IndexRequest(index, type, id).routing(routing).parent(parent).version(version).versionType(versionType).setPipeline(pipeline).source(this.sliceTrimmingCarriageReturn(data, from, nextMarker, xContentType), xContentType), payload);
                        } else {
                            this.internalAdd(new IndexRequest(index, type, id).routing(routing).parent(parent).version(version).versionType(versionType).create("create".equals(opType)).setPipeline(pipeline).source(this.sliceTrimmingCarriageReturn(data, from, nextMarker, xContentType), xContentType), payload);
                        }
                    } else if ("create".equals(action)) {
                        this.internalAdd(new IndexRequest(index, type, id).routing(routing).parent(parent).version(version).versionType(versionType).create(true).setPipeline(pipeline).source(this.sliceTrimmingCarriageReturn(data, from, nextMarker, xContentType), xContentType), payload);
                    } else if ("update".equals(action)) {
                        IndexRequest doc;
                        IndexRequest upsertRequest;
                        UpdateRequest updateRequest = new UpdateRequest(index, type, id).routing(routing).parent(parent).retryOnConflict(retryOnConflict).version(version).versionType(versionType).routing(routing).parent(parent);
                        try (StreamInput dataStream = this.sliceTrimmingCarriageReturn(data, from, nextMarker, xContentType).streamInput();
                             XContentParser sliceParser = xContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, dataStream);){
                            updateRequest.fromXContent(sliceParser);
                        }
                        if (fetchSourceContext != null) {
                            updateRequest.fetchSource(fetchSourceContext);
                        }
                        if (fields != null) {
                            updateRequest.fields(fields);
                        }
                        if ((upsertRequest = updateRequest.upsertRequest()) != null) {
                            upsertRequest.version(version);
                            upsertRequest.versionType(versionType);
                            upsertRequest.setPipeline(defaultPipeline);
                        }
                        if ((doc = updateRequest.doc()) != null) {
                            doc.version(version);
                            doc.versionType(versionType);
                        }
                        this.internalAdd(updateRequest, payload);
                    }
                    from = nextMarker + 1;
                }
                finally {
                    if (parser == null) continue;
                    parser.close();
                }
            }
            finally {
                if (stream == null) continue;
                ((InputStream)stream).close();
            }
        }
        return this;
    }

    private BytesReference sliceTrimmingCarriageReturn(BytesReference bytesReference, int from, int nextMarker, XContentType xContentType) {
        int length = XContentType.JSON == xContentType && bytesReference.get(nextMarker - 1) == 13 ? nextMarker - from - 1 : nextMarker - from;
        return bytesReference.slice(from, length);
    }

    public BulkRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public BulkRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Override
    public BulkRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    @Override
    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public final BulkRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public final BulkRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue(timeout, null, this.getClass().getSimpleName() + ".timeout"));
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    private int findNextMarker(byte marker, int from, BytesReference data, int length) {
        for (int i = from; i < length; ++i) {
            if (data.get(i) != marker) continue;
            return i;
        }
        if (from != length) {
            throw new IllegalArgumentException("The bulk request must be terminated by a newline [\n]");
        }
        return -1;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("no requests added", validationException);
        }
        for (DocWriteRequest<?> request : this.requests) {
            ActionRequestValidationException ex;
            if (((WriteRequest)((Object)request)).getRefreshPolicy() != WriteRequest.RefreshPolicy.NONE) {
                validationException = ValidateActions.addValidationError("RefreshPolicy is not supported on an item request. Set it on the BulkRequest instead.", validationException);
            }
            if ((ex = ((WriteRequest)((Object)request)).validate()) == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors(ex.validationErrors());
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            this.requests.add(DocWriteRequest.readDocumentRequest(in));
        }
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom(in);
        this.timeout = in.readTimeValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.waitForActiveShards.writeTo(out);
        out.writeVInt(this.requests.size());
        for (DocWriteRequest<?> request : this.requests) {
            DocWriteRequest.writeDocumentRequest(out, request);
        }
        this.refreshPolicy.writeTo(out);
        out.writeTimeValue(this.timeout);
    }

    @Override
    public String getDescription() {
        return "requests[" + this.requests.size() + "], indices[" + Strings.collectionToDelimitedString(this.indices, ", ") + "]";
    }
}

