/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.search;

import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.search.ParsedScrollId;
import conductor.org.elasticsearch.action.search.SearchActionListener;
import conductor.org.elasticsearch.action.search.SearchPhase;
import conductor.org.elasticsearch.action.search.SearchPhaseController;
import conductor.org.elasticsearch.action.search.SearchResponse;
import conductor.org.elasticsearch.action.search.SearchScrollAsyncAction;
import conductor.org.elasticsearch.action.search.SearchScrollRequest;
import conductor.org.elasticsearch.action.search.SearchTask;
import conductor.org.elasticsearch.action.search.SearchTransportService;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.util.concurrent.AtomicArray;
import conductor.org.elasticsearch.search.fetch.QueryFetchSearchResult;
import conductor.org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import conductor.org.elasticsearch.search.internal.InternalScrollSearchRequest;
import conductor.org.elasticsearch.transport.Transport;
import java.util.function.BiFunction;

final class SearchScrollQueryAndFetchAsyncAction
extends SearchScrollAsyncAction<ScrollQueryFetchSearchResult> {
    private final SearchTask task;
    private final AtomicArray<QueryFetchSearchResult> queryFetchResults;

    SearchScrollQueryAndFetchAsyncAction(Logger logger, ClusterService clusterService, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController, SearchScrollRequest request, SearchTask task, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
        super(scrollId, logger, clusterService.state().nodes(), listener, searchPhaseController, request, searchTransportService);
        this.task = task;
        this.queryFetchResults = new AtomicArray(scrollId.getContext().length);
    }

    @Override
    protected void executeInitialPhase(Transport.Connection connection, InternalScrollSearchRequest internalRequest, SearchActionListener<ScrollQueryFetchSearchResult> searchActionListener) {
        this.searchTransportService.sendExecuteScrollFetch(connection, internalRequest, this.task, searchActionListener);
    }

    @Override
    protected SearchPhase moveToNextPhase(BiFunction<String, String, DiscoveryNode> clusterNodeLookup) {
        return this.sendResponsePhase(this.searchPhaseController.reducedQueryPhase(this.queryFetchResults.asList(), true), this.queryFetchResults);
    }

    @Override
    protected void onFirstPhaseResult(int shardId, ScrollQueryFetchSearchResult result) {
        this.queryFetchResults.setOnce(shardId, result.result());
    }
}

