/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.ingest.DeletePipelineRequest;
import conductor.org.elasticsearch.action.ingest.GetPipelineRequest;
import conductor.org.elasticsearch.action.ingest.GetPipelineResponse;
import conductor.org.elasticsearch.action.ingest.PutPipelineRequest;
import conductor.org.elasticsearch.action.ingest.SimulatePipelineRequest;
import conductor.org.elasticsearch.action.ingest.SimulatePipelineResponse;
import conductor.org.elasticsearch.action.support.master.AcknowledgedResponse;
import conductor.org.elasticsearch.client.IngestRequestConverters;
import conductor.org.elasticsearch.client.RequestOptions;
import conductor.org.elasticsearch.client.RestHighLevelClient;
import java.io.IOException;
import java.util.Collections;

public final class IngestClient {
    private final RestHighLevelClient restHighLevelClient;

    IngestClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public AcknowledgedResponse putPipeline(PutPipelineRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, IngestRequestConverters::putPipeline, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void putPipelineAsync(PutPipelineRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IngestRequestConverters::putPipeline, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetPipelineResponse getPipeline(GetPipelineRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, IngestRequestConverters::getPipeline, options, GetPipelineResponse::fromXContent, Collections.singleton(404));
    }

    public void getPipelineAsync(GetPipelineRequest request, RequestOptions options, ActionListener<GetPipelineResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IngestRequestConverters::getPipeline, options, GetPipelineResponse::fromXContent, listener, Collections.singleton(404));
    }

    public AcknowledgedResponse deletePipeline(DeletePipelineRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, IngestRequestConverters::deletePipeline, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void deletePipelineAsync(DeletePipelineRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IngestRequestConverters::deletePipeline, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public SimulatePipelineResponse simulate(SimulatePipelineRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, IngestRequestConverters::simulatePipeline, options, SimulatePipelineResponse::fromXContent, Collections.emptySet());
    }

    public void simulateAsync(SimulatePipelineRequest request, RequestOptions options, ActionListener<SimulatePipelineResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IngestRequestConverters::simulatePipeline, options, SimulatePipelineResponse::fromXContent, listener, Collections.emptySet());
    }
}

