/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.cluster.routing;

import conductor.org.apache.lucene.util.CollectionUtil;
import conductor.org.elasticsearch.cluster.routing.ShardIterator;
import java.util.Iterator;
import java.util.List;

public final class GroupShardsIterator<ShardIt extends ShardIterator>
implements Iterable<ShardIt> {
    private final List<ShardIt> iterators;

    public GroupShardsIterator(List<ShardIt> iterators) {
        CollectionUtil.timSort(iterators);
        this.iterators = iterators;
    }

    public int totalSize() {
        int size = 0;
        for (ShardIterator shard : this.iterators) {
            size += shard.size();
        }
        return size;
    }

    public int totalSizeWith1ForEmpty() {
        int size = 0;
        for (ShardIterator shard : this.iterators) {
            size += Math.max(1, shard.size());
        }
        return size;
    }

    public int size() {
        return this.iterators.size();
    }

    @Override
    public Iterator<ShardIt> iterator() {
        return this.iterators.iterator();
    }

    public ShardIt get(int index) {
        return (ShardIt)((ShardIterator)this.iterators.get(index));
    }
}

