/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.analysis;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.env.Environment;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.indices.analysis.AnalysisModule;
import conductor.org.elasticsearch.indices.analysis.PreBuiltCacheFactory;
import java.io.IOException;

public abstract class PreConfiguredAnalysisComponent<T>
implements AnalysisModule.AnalysisProvider<T> {
    private final String name;
    protected final PreBuiltCacheFactory.PreBuiltCache<T> cache;

    protected PreConfiguredAnalysisComponent(String name, PreBuiltCacheFactory.CachingStrategy cache) {
        this.name = name;
        this.cache = PreBuiltCacheFactory.getCache(cache);
    }

    protected PreConfiguredAnalysisComponent(String name, PreBuiltCacheFactory.PreBuiltCache<T> cache) {
        this.name = name;
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
        Version versionCreated = Version.indexCreated(settings);
        PreConfiguredAnalysisComponent preConfiguredAnalysisComponent = this;
        synchronized (preConfiguredAnalysisComponent) {
            T factory = this.cache.get(versionCreated);
            if (factory == null) {
                factory = this.create(versionCreated);
                this.cache.put(versionCreated, factory);
            }
            return factory;
        }
    }

    public String getName() {
        return this.name;
    }

    protected abstract T create(Version var1);
}

