/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.search;

import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.miscellaneous.DisableGraphAttribute;
import conductor.org.apache.lucene.index.IndexOptions;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.queries.ExtendedCommonTermsQuery;
import conductor.org.apache.lucene.search.BooleanClause;
import conductor.org.apache.lucene.search.BooleanQuery;
import conductor.org.apache.lucene.search.BoostQuery;
import conductor.org.apache.lucene.search.FuzzyQuery;
import conductor.org.apache.lucene.search.MultiPhraseQuery;
import conductor.org.apache.lucene.search.MultiTermQuery;
import conductor.org.apache.lucene.search.PhraseQuery;
import conductor.org.apache.lucene.search.PrefixQuery;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.SynonymQuery;
import conductor.org.apache.lucene.search.TermQuery;
import conductor.org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import conductor.org.apache.lucene.search.spans.SpanNearQuery;
import conductor.org.apache.lucene.search.spans.SpanOrQuery;
import conductor.org.apache.lucene.search.spans.SpanQuery;
import conductor.org.apache.lucene.search.spans.SpanTermQuery;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.QueryBuilder;
import conductor.org.apache.lucene.util.graph.GraphTokenStreamFiniteStrings;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.logging.Loggers;
import conductor.org.elasticsearch.common.lucene.Lucene;
import conductor.org.elasticsearch.common.lucene.all.AllTermQuery;
import conductor.org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;
import conductor.org.elasticsearch.common.lucene.search.Queries;
import conductor.org.elasticsearch.common.unit.Fuzziness;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import conductor.org.elasticsearch.index.query.support.QueryParsers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class MatchQuery {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(MappedFieldType.class));
    public static final int DEFAULT_PHRASE_SLOP = 0;
    public static final boolean DEFAULT_LENIENCY = false;
    public static final ZeroTermsQuery DEFAULT_ZERO_TERMS_QUERY = ZeroTermsQuery.NONE;
    protected final QueryShardContext context;
    protected Analyzer analyzer;
    protected BooleanClause.Occur occur = BooleanClause.Occur.SHOULD;
    protected boolean enablePositionIncrements = true;
    protected int phraseSlop = 0;
    protected Fuzziness fuzziness = null;
    protected int fuzzyPrefixLength = 0;
    protected int maxExpansions = 50;
    protected boolean transpositions = true;
    protected MultiTermQuery.RewriteMethod fuzzyRewriteMethod;
    protected boolean lenient = false;
    protected ZeroTermsQuery zeroTermsQuery = DEFAULT_ZERO_TERMS_QUERY;
    protected Float commonTermsCutoff = null;
    protected boolean autoGenerateSynonymsPhraseQuery = true;

    public MatchQuery(QueryShardContext context) {
        this.context = context;
    }

    public void setAnalyzer(String analyzerName) {
        this.analyzer = this.context.getMapperService().getIndexAnalyzers().get(analyzerName);
        if (this.analyzer == null) {
            throw new IllegalArgumentException("No analyzer found for [" + analyzerName + "]");
        }
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void setOccur(BooleanClause.Occur occur) {
        this.occur = occur;
    }

    public void setCommonTermsCutoff(Float cutoff) {
        this.commonTermsCutoff = cutoff;
    }

    public void setEnablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
    }

    public void setPhraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public void setFuzziness(Fuzziness fuzziness) {
        this.fuzziness = fuzziness;
    }

    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
    }

    public void setMaxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
    }

    public void setTranspositions(boolean transpositions) {
        this.transpositions = transpositions;
    }

    public void setFuzzyRewriteMethod(MultiTermQuery.RewriteMethod fuzzyRewriteMethod) {
        this.fuzzyRewriteMethod = fuzzyRewriteMethod;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public void setZeroTermsQuery(ZeroTermsQuery zeroTermsQuery) {
        this.zeroTermsQuery = zeroTermsQuery;
    }

    public void setAutoGenerateSynonymsPhraseQuery(boolean enabled) {
        this.autoGenerateSynonymsPhraseQuery = enabled;
    }

    protected Analyzer getAnalyzer(MappedFieldType fieldType, boolean quoted) {
        if (this.analyzer == null) {
            return quoted ? this.context.getSearchQuoteAnalyzer(fieldType) : this.context.getSearchAnalyzer(fieldType);
        }
        return this.analyzer;
    }

    private boolean hasPositions(MappedFieldType fieldType) {
        return fieldType.indexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
    }

    public Query parse(Type type, String fieldName, Object value) throws IOException {
        MappedFieldType fieldType = this.context.fieldMapper(fieldName);
        if (fieldType == null) {
            return Queries.newUnmappedFieldQuery(fieldName);
        }
        String field = fieldType.name();
        Analyzer analyzer = this.getAnalyzer(fieldType, type == Type.PHRASE);
        assert (analyzer != null);
        if (analyzer == Lucene.KEYWORD_ANALYZER) {
            return this.blendTermQuery(new Term(fieldName, value.toString()), fieldType);
        }
        MatchQueryBuilder builder = new MatchQueryBuilder(analyzer, fieldType);
        builder.setEnablePositionIncrements(this.enablePositionIncrements);
        if (this.hasPositions(fieldType)) {
            builder.setAutoGenerateMultiTermSynonymsPhraseQuery(this.autoGenerateSynonymsPhraseQuery);
        } else {
            builder.setAutoGenerateMultiTermSynonymsPhraseQuery(false);
        }
        Query query = null;
        switch (type) {
            case BOOLEAN: {
                if (this.commonTermsCutoff == null) {
                    query = builder.createBooleanQuery(field, value.toString(), this.occur);
                    break;
                }
                query = builder.createCommonTermsQuery(field, value.toString(), this.occur, this.occur, this.commonTermsCutoff.floatValue(), fieldType);
                break;
            }
            case PHRASE: {
                query = builder.createPhraseQuery(field, value.toString(), this.phraseSlop);
                break;
            }
            case PHRASE_PREFIX: {
                query = builder.createPhrasePrefixQuery(field, value.toString(), this.phraseSlop, this.maxExpansions);
                break;
            }
            default: {
                throw new IllegalStateException("No type found for [" + type + "]");
            }
        }
        if (query == null) {
            return this.zeroTermsQuery();
        }
        return query;
    }

    protected final Query termQuery(MappedFieldType fieldType, BytesRef value, boolean lenient) {
        try {
            return fieldType.termQuery(value, this.context);
        }
        catch (RuntimeException e) {
            if (lenient) {
                return Queries.newLenientFieldQuery(fieldType.name(), e);
            }
            throw e;
        }
    }

    protected Query zeroTermsQuery() {
        switch (this.zeroTermsQuery) {
            case NULL: {
                return null;
            }
            case NONE: {
                return Queries.newMatchNoDocsQuery("Matching no documents because no terms present");
            }
            case ALL: {
                return Queries.newMatchAllQuery();
            }
        }
        throw new IllegalStateException("unknown zeroTermsQuery " + this.zeroTermsQuery);
    }

    protected Query blendPhraseQuery(PhraseQuery query, MappedFieldType fieldType) {
        return query;
    }

    protected Query blendTermsQuery(Term[] terms, MappedFieldType fieldType) {
        return new SynonymQuery(terms);
    }

    protected Query blendTermQuery(Term term, MappedFieldType fieldType) {
        if (this.fuzziness != null) {
            try {
                Query query = fieldType.fuzzyQuery(term.text(), this.fuzziness, this.fuzzyPrefixLength, this.maxExpansions, this.transpositions);
                if (query instanceof FuzzyQuery) {
                    QueryParsers.setRewriteMethod((FuzzyQuery)query, this.fuzzyRewriteMethod);
                }
                return query;
            }
            catch (RuntimeException e) {
                if (this.lenient) {
                    return Queries.newLenientFieldQuery(fieldType.name(), e);
                }
                throw e;
            }
        }
        return this.termQuery(fieldType, term.bytes(), this.lenient);
    }

    private class MatchQueryBuilder
    extends QueryBuilder {
        private final MappedFieldType mapper;

        MatchQueryBuilder(Analyzer analyzer, MappedFieldType mapper) {
            super(analyzer);
            this.mapper = mapper;
        }

        @Override
        protected Query newTermQuery(Term term) {
            return MatchQuery.this.blendTermQuery(term, this.mapper);
        }

        @Override
        protected Query newSynonymQuery(Term[] terms) {
            return MatchQuery.this.blendTermsQuery(terms, this.mapper);
        }

        @Override
        protected Query analyzePhrase(String field, TokenStream stream, int slop) throws IOException {
            try {
                this.checkForPositions(field);
                Query query = this.mapper.phraseQuery(field, stream, slop, this.enablePositionIncrements);
                if (query instanceof PhraseQuery) {
                    return MatchQuery.this.blendPhraseQuery((PhraseQuery)query, this.mapper);
                }
                return query;
            }
            catch (IllegalStateException e) {
                if (MatchQuery.this.lenient) {
                    return Queries.newLenientFieldQuery(field, e);
                }
                throw e;
            }
            catch (IllegalArgumentException e) {
                if (!MatchQuery.this.lenient) {
                    DEPRECATION_LOGGER.deprecated(e.getMessage(), new Object[0]);
                }
                return Queries.newLenientFieldQuery(field, e);
            }
        }

        @Override
        protected Query analyzeMultiPhrase(String field, TokenStream stream, int slop) throws IOException {
            try {
                this.checkForPositions(field);
                return this.mapper.multiPhraseQuery(field, stream, slop, this.enablePositionIncrements);
            }
            catch (IllegalStateException e) {
                if (MatchQuery.this.lenient) {
                    return Queries.newLenientFieldQuery(field, e);
                }
                throw e;
            }
            catch (IllegalArgumentException e) {
                if (!MatchQuery.this.lenient) {
                    DEPRECATION_LOGGER.deprecated(e.getMessage(), new Object[0]);
                }
                return Queries.newLenientFieldQuery(field, e);
            }
        }

        private void checkForPositions(String field) {
            if (!MatchQuery.this.hasPositions(this.mapper)) {
                throw new IllegalStateException("field:[" + field + "] was indexed without position data; cannot run PhraseQuery");
            }
        }

        @Override
        protected Query createFieldQuery(Analyzer analyzer, BooleanClause.Occur operator, String field, String queryText, boolean quoted, int phraseSlop) {
            Query query;
            block10: {
                assert (operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST);
                TokenStream source = analyzer.tokenStream(field, queryText);
                try {
                    if (source.hasAttribute(DisableGraphAttribute.class)) {
                        this.setEnableGraphQueries(false);
                    }
                    Query query2 = super.createFieldQuery(source, operator, field, quoted, phraseSlop);
                    this.setEnableGraphQueries(true);
                    query = query2;
                    if (source == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (source != null) {
                            try {
                                source.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error analyzing query text", e);
                    }
                }
                source.close();
            }
            return query;
        }

        public Query createPhrasePrefixQuery(String field, String queryText, int phraseSlop, int maxExpansions) {
            Query query = this.createFieldQuery(this.getAnalyzer(), BooleanClause.Occur.MUST, field, queryText, true, phraseSlop);
            return this.toMultiPhrasePrefix(query, phraseSlop, maxExpansions);
        }

        private Query toMultiPhrasePrefix(Query query, int phraseSlop, int maxExpansions) {
            float boost = 1.0f;
            Query innerQuery = query;
            while (innerQuery instanceof BoostQuery) {
                BoostQuery bq = (BoostQuery)innerQuery;
                boost *= bq.getBoost();
                innerQuery = bq.getQuery();
            }
            if (query instanceof SpanQuery) {
                return this.toSpanQueryPrefix((SpanQuery)query, boost);
            }
            MultiPhrasePrefixQuery prefixQuery = new MultiPhrasePrefixQuery();
            prefixQuery.setMaxExpansions(maxExpansions);
            prefixQuery.setSlop(phraseSlop);
            if (innerQuery instanceof PhraseQuery) {
                PhraseQuery pq = (PhraseQuery)innerQuery;
                Term[] terms = pq.getTerms();
                int[] positions = pq.getPositions();
                for (int i = 0; i < terms.length; ++i) {
                    prefixQuery.add(new Term[]{terms[i]}, positions[i]);
                }
                return boost == 1.0f ? prefixQuery : new BoostQuery(prefixQuery, boost);
            }
            if (innerQuery instanceof MultiPhraseQuery) {
                MultiPhraseQuery pq = (MultiPhraseQuery)innerQuery;
                Term[][] terms = pq.getTermArrays();
                int[] positions = pq.getPositions();
                for (int i = 0; i < terms.length; ++i) {
                    prefixQuery.add(terms[i], positions[i]);
                }
                return boost == 1.0f ? prefixQuery : new BoostQuery(prefixQuery, boost);
            }
            if (innerQuery instanceof TermQuery) {
                prefixQuery.add(((TermQuery)innerQuery).getTerm());
                return boost == 1.0f ? prefixQuery : new BoostQuery(prefixQuery, boost);
            }
            if (innerQuery instanceof AllTermQuery) {
                prefixQuery.add(((AllTermQuery)innerQuery).getTerm());
                return boost == 1.0f ? prefixQuery : new BoostQuery(prefixQuery, boost);
            }
            return query;
        }

        private Query toSpanQueryPrefix(SpanQuery query, float boost) {
            if (query instanceof SpanTermQuery) {
                SpanMultiTermQueryWrapper<PrefixQuery> ret = new SpanMultiTermQueryWrapper<PrefixQuery>(new PrefixQuery(((SpanTermQuery)query).getTerm()));
                return boost == 1.0f ? ret : new BoostQuery(ret, boost);
            }
            if (query instanceof SpanNearQuery) {
                SpanNearQuery spanNearQuery = (SpanNearQuery)query;
                SpanQuery[] clauses = spanNearQuery.getClauses();
                if (clauses[clauses.length - 1] instanceof SpanTermQuery) {
                    clauses[clauses.length - 1] = new SpanMultiTermQueryWrapper<PrefixQuery>(new PrefixQuery(((SpanTermQuery)clauses[clauses.length - 1]).getTerm()));
                }
                SpanNearQuery newQuery = new SpanNearQuery(clauses, spanNearQuery.getSlop(), spanNearQuery.isInOrder());
                return boost == 1.0f ? newQuery : new BoostQuery(newQuery, boost);
            }
            if (query instanceof SpanOrQuery) {
                SpanOrQuery orQuery = (SpanOrQuery)query;
                SpanQuery[] clauses = new SpanQuery[orQuery.getClauses().length];
                for (int i = 0; i < clauses.length; ++i) {
                    clauses[i] = (SpanQuery)this.toSpanQueryPrefix(orQuery.getClauses()[i], 1.0f);
                }
                return boost == 1.0f ? new SpanOrQuery(clauses) : new BoostQuery(new SpanOrQuery(clauses), boost);
            }
            return query;
        }

        public Query createCommonTermsQuery(String field, String queryText, BooleanClause.Occur highFreqOccur, BooleanClause.Occur lowFreqOccur, float maxTermFrequency, MappedFieldType fieldType) {
            Query booleanQuery = this.createBooleanQuery(field, queryText, lowFreqOccur);
            if (booleanQuery != null && booleanQuery instanceof BooleanQuery) {
                BooleanQuery bq = (BooleanQuery)booleanQuery;
                return this.boolToExtendedCommonTermsQuery(bq, highFreqOccur, lowFreqOccur, maxTermFrequency, fieldType);
            }
            return booleanQuery;
        }

        private Query boolToExtendedCommonTermsQuery(BooleanQuery bq, BooleanClause.Occur highFreqOccur, BooleanClause.Occur lowFreqOccur, float maxTermFrequency, MappedFieldType fieldType) {
            ExtendedCommonTermsQuery query = new ExtendedCommonTermsQuery(highFreqOccur, lowFreqOccur, maxTermFrequency, fieldType);
            for (BooleanClause clause : bq.clauses()) {
                if (!(clause.getQuery() instanceof TermQuery)) {
                    return bq;
                }
                query.add(((TermQuery)clause.getQuery()).getTerm());
            }
            return query;
        }

        @Override
        protected SpanQuery analyzeGraphPhrase(TokenStream source, String field, int phraseSlop) throws IOException {
            source.reset();
            GraphTokenStreamFiniteStrings graph = new GraphTokenStreamFiniteStrings(source);
            ArrayList<SpanTermQuery> clauses = new ArrayList<SpanTermQuery>();
            int[] articulationPoints = graph.articulationPoints();
            int lastState = 0;
            int maxBooleanClause = BooleanQuery.getMaxClauseCount();
            for (int i = 0; i <= articulationPoints.length; ++i) {
                SpanQuery queryPos;
                int start = lastState;
                int end = -1;
                if (i < articulationPoints.length) {
                    end = articulationPoints[i];
                }
                lastState = end;
                if (graph.hasSidePath(start)) {
                    ArrayList<SpanQuery> queries = new ArrayList<SpanQuery>();
                    Iterator<TokenStream> it = graph.getFiniteStrings(start, end);
                    while (it.hasNext()) {
                        TokenStream ts = it.next();
                        SpanQuery q = this.createSpanQuery(ts, field);
                        if (q == null) continue;
                        if (queries.size() >= maxBooleanClause) {
                            throw new BooleanQuery.TooManyClauses();
                        }
                        queries.add(q);
                    }
                    queryPos = queries.size() > 0 ? new SpanOrQuery(queries.toArray(new SpanQuery[0])) : null;
                } else {
                    Term[] terms = graph.getTerms(field, start);
                    assert (terms.length > 0);
                    if (terms.length >= maxBooleanClause) {
                        throw new BooleanQuery.TooManyClauses();
                    }
                    if (terms.length == 1) {
                        queryPos = new SpanTermQuery(terms[0]);
                    } else {
                        SpanQuery[] orClauses = new SpanTermQuery[terms.length];
                        for (int idx = 0; idx < terms.length; ++idx) {
                            orClauses[idx] = new SpanTermQuery(terms[idx]);
                        }
                        queryPos = new SpanOrQuery(orClauses);
                    }
                }
                if (queryPos == null) continue;
                if (clauses.size() >= maxBooleanClause) {
                    throw new BooleanQuery.TooManyClauses();
                }
                clauses.add((SpanTermQuery)queryPos);
            }
            if (clauses.isEmpty()) {
                return null;
            }
            if (clauses.size() == 1) {
                return (SpanQuery)clauses.get(0);
            }
            return new SpanNearQuery(clauses.toArray(new SpanQuery[0]), phraseSlop, true);
        }
    }

    public static enum ZeroTermsQuery implements Writeable
    {
        NONE(0),
        ALL(1),
        NULL(2);

        private final int ordinal;

        private ZeroTermsQuery(int ordinal) {
            this.ordinal = ordinal;
        }

        public static ZeroTermsQuery readFromStream(StreamInput in) throws IOException {
            int ord = in.readVInt();
            for (ZeroTermsQuery zeroTermsQuery : ZeroTermsQuery.values()) {
                if (zeroTermsQuery.ordinal != ord) continue;
                return zeroTermsQuery;
            }
            throw new ElasticsearchException("unknown serialized type [" + ord + "]", new Object[0]);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal);
        }
    }

    public static enum Type implements Writeable
    {
        BOOLEAN(0),
        PHRASE(1),
        PHRASE_PREFIX(2);

        private final int ordinal;

        private Type(int ordinal) {
            this.ordinal = ordinal;
        }

        public static Type readFromStream(StreamInput in) throws IOException {
            int ord = in.readVInt();
            for (Type type : Type.values()) {
                if (type.ordinal != ord) continue;
                return type;
            }
            throw new ElasticsearchException("unknown serialized type [" + ord + "]", new Object[0]);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal);
        }
    }
}

