/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.admin.cluster;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.allocation.ClusterAllocationExplainRequest;
import conductor.org.elasticsearch.action.admin.cluster.allocation.ClusterAllocationExplainResponse;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.BytesRestResponse;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.RestResponse;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.rest.action.RestBuilderListener;
import java.io.IOException;

public class RestClusterAllocationExplainAction
extends BaseRestHandler {
    public RestClusterAllocationExplainAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/allocation/explain", this);
        controller.registerHandler(RestRequest.Method.POST, "/_cluster/allocation/explain", this);
    }

    @Override
    public String getName() {
        return "cluster_allocation_explain_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ClusterAllocationExplainRequest req;
        if (!request.hasContentOrSourceParam()) {
            req = new ClusterAllocationExplainRequest();
        } else {
            try (XContentParser parser = request.contentOrSourceParamParser();){
                req = ClusterAllocationExplainRequest.parse(parser);
            }
        }
        req.includeYesDecisions(request.paramAsBoolean("include_yes_decisions", false));
        req.includeDiskInfo(request.paramAsBoolean("include_disk_info", false));
        return channel -> client.admin().cluster().allocationExplain(req, (ActionListener<ClusterAllocationExplainResponse>)new RestBuilderListener<ClusterAllocationExplainResponse>(channel){

            @Override
            public RestResponse buildResponse(ClusterAllocationExplainResponse response, XContentBuilder builder) throws IOException {
                response.getExplanation().toXContent(builder, ToXContent.EMPTY_PARAMS);
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

