/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search;

import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.rest.RestStatus;
import java.io.IOException;

public class SearchContextMissingException
extends ElasticsearchException {
    private final long id;

    public SearchContextMissingException(long id) {
        super("No search context found for id [" + id + "]", new Object[0]);
        this.id = id;
    }

    public long id() {
        return this.id;
    }

    @Override
    public RestStatus status() {
        return RestStatus.NOT_FOUND;
    }

    public SearchContextMissingException(StreamInput in) throws IOException {
        super(in);
        this.id = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.id);
    }
}

