/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.profile;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.search.profile.aggregation.AggregationProfileShardResult;
import conductor.org.elasticsearch.search.profile.query.QueryProfileShardResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProfileShardResult
implements Writeable {
    private final List<QueryProfileShardResult> queryProfileResults;
    private final AggregationProfileShardResult aggProfileShardResult;

    public ProfileShardResult(List<QueryProfileShardResult> queryProfileResults, AggregationProfileShardResult aggProfileShardResult) {
        this.aggProfileShardResult = aggProfileShardResult;
        this.queryProfileResults = Collections.unmodifiableList(queryProfileResults);
    }

    public ProfileShardResult(StreamInput in) throws IOException {
        int profileSize = in.readVInt();
        ArrayList<QueryProfileShardResult> queryProfileResults = new ArrayList<QueryProfileShardResult>(profileSize);
        for (int i = 0; i < profileSize; ++i) {
            QueryProfileShardResult result = new QueryProfileShardResult(in);
            queryProfileResults.add(result);
        }
        this.queryProfileResults = Collections.unmodifiableList(queryProfileResults);
        this.aggProfileShardResult = new AggregationProfileShardResult(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.queryProfileResults.size());
        for (QueryProfileShardResult queryShardResult : this.queryProfileResults) {
            queryShardResult.writeTo(out);
        }
        this.aggProfileShardResult.writeTo(out);
    }

    public List<QueryProfileShardResult> getQueryProfileResults() {
        return this.queryProfileResults;
    }

    public AggregationProfileShardResult getAggregationProfileResults() {
        return this.aggProfileShardResult;
    }
}

