/*
 * Decompiled with CFR 0.152.
 */
package conductor.com.carrotsearch.hppc;

import conductor.com.carrotsearch.hppc.ShortCollection;
import conductor.com.carrotsearch.hppc.ShortLookupContainer;
import conductor.com.carrotsearch.hppc.cursors.ShortCursor;
import conductor.com.carrotsearch.hppc.predicates.ShortPredicate;
import java.util.Arrays;

abstract class AbstractShortCollection
implements ShortCollection {
    AbstractShortCollection() {
    }

    @Override
    public int removeAll(final ShortLookupContainer c) {
        return this.removeAll(new ShortPredicate(){

            @Override
            public boolean apply(short k) {
                return c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final ShortLookupContainer c) {
        return this.removeAll(new ShortPredicate(){

            @Override
            public boolean apply(short k) {
                return !c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final ShortPredicate predicate) {
        return this.removeAll(new ShortPredicate(){

            @Override
            public boolean apply(short value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public short[] toArray() {
        short[] array = new short[this.size()];
        int i = 0;
        for (ShortCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

