/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.shards;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsGroup;
import conductor.org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import conductor.org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.cluster.routing.GroupShardsIterator;
import conductor.org.elasticsearch.cluster.routing.ShardIterator;
import conductor.org.elasticsearch.cluster.routing.ShardRouting;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.indices.IndicesService;
import conductor.org.elasticsearch.search.internal.AliasFilter;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TransportClusterSearchShardsAction
extends TransportMasterNodeReadAction<ClusterSearchShardsRequest, ClusterSearchShardsResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportClusterSearchShardsAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:admin/shards/search_shards", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, ClusterSearchShardsRequest::new);
        this.indicesService = indicesService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterSearchShardsRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    @Override
    protected ClusterSearchShardsResponse newResponse() {
        return new ClusterSearchShardsResponse();
    }

    @Override
    protected void masterOperation(ClusterSearchShardsRequest request, ClusterState state, ActionListener<ClusterSearchShardsResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(clusterState, request);
        Map<String, Set<String>> routingMap = this.indexNameExpressionResolver.resolveSearchRouting(state, request.routing(), request.indices());
        HashMap<String, AliasFilter> indicesAndFilters = new HashMap<String, AliasFilter>();
        for (String index : concreteIndices) {
            AliasFilter aliasFilter = this.indicesService.buildAliasFilter(clusterState, index, request.indices());
            String[] aliases = this.indexNameExpressionResolver.indexAliases(clusterState, index, aliasMetadata -> true, true, request.indices());
            indicesAndFilters.put(index, new AliasFilter(aliasFilter.getQueryBuilder(), aliases));
        }
        HashSet<String> nodeIds = new HashSet<String>();
        GroupShardsIterator<ShardIterator> groupShardsIterator = this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, routingMap, request.preference());
        ClusterSearchShardsGroup[] groupResponses = new ClusterSearchShardsGroup[groupShardsIterator.size()];
        int currentGroup = 0;
        for (ShardIterator shardIt : groupShardsIterator) {
            ShardRouting shard;
            ShardId shardId = shardIt.shardId();
            ShardRouting[] shardRoutings = new ShardRouting[shardIt.size()];
            int currentShard = 0;
            shardIt.reset();
            while ((shard = shardIt.nextOrNull()) != null) {
                shardRoutings[currentShard++] = shard;
                nodeIds.add(shard.currentNodeId());
            }
            groupResponses[currentGroup++] = new ClusterSearchShardsGroup(shardId, shardRoutings);
        }
        DiscoveryNode[] nodes = new DiscoveryNode[nodeIds.size()];
        int currentNode = 0;
        for (String nodeId : nodeIds) {
            nodes[currentNode++] = clusterState.getNodes().get(nodeId);
        }
        listener.onResponse(new ClusterSearchShardsResponse(groupResponses, nodes, indicesAndFilters));
    }
}

