/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.indices.stats;

import conductor.org.apache.lucene.store.AlreadyClosedException;
import conductor.org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.unit.ByteSizeValue;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.index.cache.query.QueryCacheStats;
import conductor.org.elasticsearch.index.cache.request.RequestCacheStats;
import conductor.org.elasticsearch.index.engine.SegmentsStats;
import conductor.org.elasticsearch.index.fielddata.FieldDataStats;
import conductor.org.elasticsearch.index.flush.FlushStats;
import conductor.org.elasticsearch.index.get.GetStats;
import conductor.org.elasticsearch.index.merge.MergeStats;
import conductor.org.elasticsearch.index.recovery.RecoveryStats;
import conductor.org.elasticsearch.index.refresh.RefreshStats;
import conductor.org.elasticsearch.index.search.stats.SearchStats;
import conductor.org.elasticsearch.index.shard.DocsStats;
import conductor.org.elasticsearch.index.shard.IndexShard;
import conductor.org.elasticsearch.index.shard.IndexingStats;
import conductor.org.elasticsearch.index.store.StoreStats;
import conductor.org.elasticsearch.index.translog.TranslogStats;
import conductor.org.elasticsearch.index.warmer.WarmerStats;
import conductor.org.elasticsearch.indices.IndicesQueryCache;
import conductor.org.elasticsearch.search.suggest.completion.CompletionStats;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;

public class CommonStats
implements Writeable,
ToXContentFragment {
    @Nullable
    public DocsStats docs;
    @Nullable
    public StoreStats store;
    @Nullable
    public IndexingStats indexing;
    @Nullable
    public GetStats get;
    @Nullable
    public SearchStats search;
    @Nullable
    public MergeStats merge;
    @Nullable
    public RefreshStats refresh;
    @Nullable
    public FlushStats flush;
    @Nullable
    public WarmerStats warmer;
    @Nullable
    public QueryCacheStats queryCache;
    @Nullable
    public FieldDataStats fieldData;
    @Nullable
    public CompletionStats completion;
    @Nullable
    public SegmentsStats segments;
    @Nullable
    public TranslogStats translog;
    @Nullable
    public RequestCacheStats requestCache;
    @Nullable
    public RecoveryStats recoveryStats;

    public CommonStats() {
        this(CommonStatsFlags.NONE);
    }

    public CommonStats(CommonStatsFlags flags) {
        CommonStatsFlags.Flag[] setFlags;
        block19: for (CommonStatsFlags.Flag flag : setFlags = flags.getFlags()) {
            switch (flag) {
                case Docs: {
                    this.docs = new DocsStats();
                    continue block19;
                }
                case Store: {
                    this.store = new StoreStats();
                    continue block19;
                }
                case Indexing: {
                    this.indexing = new IndexingStats();
                    continue block19;
                }
                case Get: {
                    this.get = new GetStats();
                    continue block19;
                }
                case Search: {
                    this.search = new SearchStats();
                    continue block19;
                }
                case Merge: {
                    this.merge = new MergeStats();
                    continue block19;
                }
                case Refresh: {
                    this.refresh = new RefreshStats();
                    continue block19;
                }
                case Flush: {
                    this.flush = new FlushStats();
                    continue block19;
                }
                case Warmer: {
                    this.warmer = new WarmerStats();
                    continue block19;
                }
                case QueryCache: {
                    this.queryCache = new QueryCacheStats();
                    continue block19;
                }
                case FieldData: {
                    this.fieldData = new FieldDataStats();
                    continue block19;
                }
                case Completion: {
                    this.completion = new CompletionStats();
                    continue block19;
                }
                case Segments: {
                    this.segments = new SegmentsStats();
                    continue block19;
                }
                case Translog: {
                    this.translog = new TranslogStats();
                    continue block19;
                }
                case Suggest: {
                    continue block19;
                }
                case RequestCache: {
                    this.requestCache = new RequestCacheStats();
                    continue block19;
                }
                case Recovery: {
                    this.recoveryStats = new RecoveryStats();
                    continue block19;
                }
                default: {
                    throw new IllegalStateException("Unknown Flag: " + (Object)((Object)flag));
                }
            }
        }
    }

    public CommonStats(IndicesQueryCache indicesQueryCache, IndexShard indexShard, CommonStatsFlags flags) {
        CommonStatsFlags.Flag[] setFlags;
        for (CommonStatsFlags.Flag flag : setFlags = flags.getFlags()) {
            try {
                switch (flag) {
                    case Docs: {
                        this.docs = indexShard.docStats();
                        break;
                    }
                    case Store: {
                        this.store = indexShard.storeStats();
                        break;
                    }
                    case Indexing: {
                        this.indexing = indexShard.indexingStats(flags.types());
                        break;
                    }
                    case Get: {
                        this.get = indexShard.getStats();
                        break;
                    }
                    case Search: {
                        this.search = indexShard.searchStats(flags.groups());
                        break;
                    }
                    case Merge: {
                        this.merge = indexShard.mergeStats();
                        break;
                    }
                    case Refresh: {
                        this.refresh = indexShard.refreshStats();
                        break;
                    }
                    case Flush: {
                        this.flush = indexShard.flushStats();
                        break;
                    }
                    case Warmer: {
                        this.warmer = indexShard.warmerStats();
                        break;
                    }
                    case QueryCache: {
                        this.queryCache = indicesQueryCache.getStats(indexShard.shardId());
                        break;
                    }
                    case FieldData: {
                        this.fieldData = indexShard.fieldDataStats(flags.fieldDataFields());
                        break;
                    }
                    case Completion: {
                        this.completion = indexShard.completionStats(flags.completionDataFields());
                        break;
                    }
                    case Segments: {
                        this.segments = indexShard.segmentStats(flags.includeSegmentFileSizes());
                        break;
                    }
                    case Translog: {
                        this.translog = indexShard.translogStats();
                        break;
                    }
                    case Suggest: {
                        break;
                    }
                    case RequestCache: {
                        this.requestCache = indexShard.requestCache().stats();
                        break;
                    }
                    case Recovery: {
                        this.recoveryStats = indexShard.recoveryStats();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown Flag: " + (Object)((Object)flag));
                    }
                }
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
    }

    public CommonStats(StreamInput in) throws IOException {
        this.docs = in.readOptionalStreamable(DocsStats::new);
        this.store = in.readOptionalStreamable(StoreStats::new);
        this.indexing = in.readOptionalStreamable(IndexingStats::new);
        this.get = in.readOptionalStreamable(GetStats::new);
        this.search = in.readOptionalWriteable(SearchStats::new);
        this.merge = in.readOptionalStreamable(MergeStats::new);
        this.refresh = in.readOptionalStreamable(RefreshStats::new);
        this.flush = in.readOptionalStreamable(FlushStats::new);
        this.warmer = in.readOptionalStreamable(WarmerStats::new);
        this.queryCache = in.readOptionalStreamable(QueryCacheStats::new);
        this.fieldData = in.readOptionalStreamable(FieldDataStats::new);
        this.completion = in.readOptionalStreamable(CompletionStats::new);
        this.segments = in.readOptionalStreamable(SegmentsStats::new);
        this.translog = in.readOptionalStreamable(TranslogStats::new);
        this.requestCache = in.readOptionalStreamable(RequestCacheStats::new);
        this.recoveryStats = in.readOptionalStreamable(RecoveryStats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalStreamable(this.docs);
        out.writeOptionalStreamable(this.store);
        out.writeOptionalStreamable(this.indexing);
        out.writeOptionalStreamable(this.get);
        out.writeOptionalWriteable(this.search);
        out.writeOptionalStreamable(this.merge);
        out.writeOptionalStreamable(this.refresh);
        out.writeOptionalStreamable(this.flush);
        out.writeOptionalStreamable(this.warmer);
        out.writeOptionalStreamable(this.queryCache);
        out.writeOptionalStreamable(this.fieldData);
        out.writeOptionalStreamable(this.completion);
        out.writeOptionalStreamable(this.segments);
        out.writeOptionalStreamable(this.translog);
        out.writeOptionalStreamable(this.requestCache);
        out.writeOptionalStreamable(this.recoveryStats);
    }

    public void add(CommonStats stats) {
        if (this.docs == null) {
            if (stats.getDocs() != null) {
                this.docs = new DocsStats();
                this.docs.add(stats.getDocs());
            }
        } else {
            this.docs.add(stats.getDocs());
        }
        if (this.store == null) {
            if (stats.getStore() != null) {
                this.store = new StoreStats();
                this.store.add(stats.getStore());
            }
        } else {
            this.store.add(stats.getStore());
        }
        if (this.indexing == null) {
            if (stats.getIndexing() != null) {
                this.indexing = new IndexingStats();
                this.indexing.add(stats.getIndexing());
            }
        } else {
            this.indexing.add(stats.getIndexing());
        }
        if (this.get == null) {
            if (stats.getGet() != null) {
                this.get = new GetStats();
                this.get.add(stats.getGet());
            }
        } else {
            this.get.add(stats.getGet());
        }
        if (this.search == null) {
            if (stats.getSearch() != null) {
                this.search = new SearchStats();
                this.search.add(stats.getSearch());
            }
        } else {
            this.search.add(stats.getSearch());
        }
        if (this.merge == null) {
            if (stats.getMerge() != null) {
                this.merge = new MergeStats();
                this.merge.add(stats.getMerge());
            }
        } else {
            this.merge.add(stats.getMerge());
        }
        if (this.refresh == null) {
            if (stats.getRefresh() != null) {
                this.refresh = new RefreshStats();
                this.refresh.add(stats.getRefresh());
            }
        } else {
            this.refresh.add(stats.getRefresh());
        }
        if (this.flush == null) {
            if (stats.getFlush() != null) {
                this.flush = new FlushStats();
                this.flush.add(stats.getFlush());
            }
        } else {
            this.flush.add(stats.getFlush());
        }
        if (this.warmer == null) {
            if (stats.getWarmer() != null) {
                this.warmer = new WarmerStats();
                this.warmer.add(stats.getWarmer());
            }
        } else {
            this.warmer.add(stats.getWarmer());
        }
        if (this.queryCache == null) {
            if (stats.getQueryCache() != null) {
                this.queryCache = new QueryCacheStats();
                this.queryCache.add(stats.getQueryCache());
            }
        } else {
            this.queryCache.add(stats.getQueryCache());
        }
        if (this.fieldData == null) {
            if (stats.getFieldData() != null) {
                this.fieldData = new FieldDataStats();
                this.fieldData.add(stats.getFieldData());
            }
        } else {
            this.fieldData.add(stats.getFieldData());
        }
        if (this.completion == null) {
            if (stats.getCompletion() != null) {
                this.completion = new CompletionStats();
                this.completion.add(stats.getCompletion());
            }
        } else {
            this.completion.add(stats.getCompletion());
        }
        if (this.segments == null) {
            if (stats.getSegments() != null) {
                this.segments = new SegmentsStats();
                this.segments.add(stats.getSegments());
            }
        } else {
            this.segments.add(stats.getSegments());
        }
        if (this.translog == null) {
            if (stats.getTranslog() != null) {
                this.translog = new TranslogStats();
                this.translog.add(stats.getTranslog());
            }
        } else {
            this.translog.add(stats.getTranslog());
        }
        if (this.requestCache == null) {
            if (stats.getRequestCache() != null) {
                this.requestCache = new RequestCacheStats();
                this.requestCache.add(stats.getRequestCache());
            }
        } else {
            this.requestCache.add(stats.getRequestCache());
        }
        if (this.recoveryStats == null) {
            if (stats.getRecoveryStats() != null) {
                this.recoveryStats = new RecoveryStats();
                this.recoveryStats.add(stats.getRecoveryStats());
            }
        } else {
            this.recoveryStats.add(stats.getRecoveryStats());
        }
    }

    @Nullable
    public DocsStats getDocs() {
        return this.docs;
    }

    @Nullable
    public StoreStats getStore() {
        return this.store;
    }

    @Nullable
    public IndexingStats getIndexing() {
        return this.indexing;
    }

    @Nullable
    public GetStats getGet() {
        return this.get;
    }

    @Nullable
    public SearchStats getSearch() {
        return this.search;
    }

    @Nullable
    public MergeStats getMerge() {
        return this.merge;
    }

    @Nullable
    public RefreshStats getRefresh() {
        return this.refresh;
    }

    @Nullable
    public FlushStats getFlush() {
        return this.flush;
    }

    @Nullable
    public WarmerStats getWarmer() {
        return this.warmer;
    }

    @Nullable
    public QueryCacheStats getQueryCache() {
        return this.queryCache;
    }

    @Nullable
    public FieldDataStats getFieldData() {
        return this.fieldData;
    }

    @Nullable
    public CompletionStats getCompletion() {
        return this.completion;
    }

    @Nullable
    public SegmentsStats getSegments() {
        return this.segments;
    }

    @Nullable
    public TranslogStats getTranslog() {
        return this.translog;
    }

    @Nullable
    public RequestCacheStats getRequestCache() {
        return this.requestCache;
    }

    @Nullable
    public RecoveryStats getRecoveryStats() {
        return this.recoveryStats;
    }

    public ByteSizeValue getTotalMemory() {
        long size = 0L;
        if (this.getFieldData() != null) {
            size += this.getFieldData().getMemorySizeInBytes();
        }
        if (this.getQueryCache() != null) {
            size += this.getQueryCache().getMemorySizeInBytes();
        }
        if (this.getSegments() != null) {
            size += this.getSegments().getMemoryInBytes() + this.getSegments().getIndexWriterMemoryInBytes() + this.getSegments().getVersionMapMemoryInBytes();
        }
        return new ByteSizeValue(size);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Stream<ToXContent> stream = Arrays.stream(new ToXContent[]{this.docs, this.store, this.indexing, this.get, this.search, this.merge, this.refresh, this.flush, this.warmer, this.queryCache, this.fieldData, this.completion, this.segments, this.translog, this.requestCache, this.recoveryStats}).filter(Objects::nonNull);
        for (ToXContent toXContent : stream::iterator) {
            toXContent.toXContent(builder, params);
        }
        return builder;
    }
}

