/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.bootstrap;

import conductor.org.apache.lucene.util.Constants;
import conductor.org.elasticsearch.bootstrap.Natives;
import conductor.org.elasticsearch.core.internal.io.IOUtils;
import conductor.org.elasticsearch.env.Environment;
import conductor.org.elasticsearch.plugins.Platforms;
import conductor.org.elasticsearch.plugins.PluginInfo;
import conductor.org.elasticsearch.plugins.PluginsService;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

final class Spawner
implements Closeable {
    private final List<Process> processes = new ArrayList<Process>();
    private AtomicBoolean spawned = new AtomicBoolean();

    Spawner() {
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(() -> this.processes.stream().map(s -> s::destroy).iterator());
    }

    void spawnNativeControllers(Environment environment) throws IOException {
        if (!this.spawned.compareAndSet(false, true)) {
            throw new IllegalStateException("native controllers already spawned");
        }
        if (!Files.exists(environment.modulesFile(), new LinkOption[0])) {
            throw new IllegalStateException("modules directory [" + environment.modulesFile() + "] not found");
        }
        List<Path> paths = PluginsService.findPluginDirs(environment.modulesFile());
        for (Path modules : paths) {
            PluginInfo info = PluginInfo.readFromProperties(modules);
            Path spawnPath = Platforms.nativeControllerPath(modules);
            if (!Files.isRegularFile(spawnPath, new LinkOption[0])) continue;
            if (!info.hasNativeController()) {
                String message = String.format(Locale.ROOT, "module [%s] does not have permission to fork native controller", modules.getFileName());
                throw new IllegalArgumentException(message);
            }
            Process process = this.spawnNativeController(spawnPath, environment.tmpFile());
            this.processes.add(process);
        }
    }

    private Process spawnNativeController(Path spawnPath, Path tmpPath) throws IOException {
        String command = Constants.WINDOWS ? Natives.getShortPathName(spawnPath.toString()) : spawnPath.toString();
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.environment().clear();
        pb.environment().put("TMPDIR", tmpPath.toString());
        return pb.start();
    }

    List<Process> getProcesses() {
        return Collections.unmodifiableList(this.processes);
    }
}

