/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.apache.http.ContentTooLongException;
import conductor.org.apache.http.HttpEntity;
import conductor.org.apache.http.HttpException;
import conductor.org.apache.http.HttpResponse;
import conductor.org.apache.http.entity.ContentType;
import conductor.org.apache.http.nio.ContentDecoder;
import conductor.org.apache.http.nio.IOControl;
import conductor.org.apache.http.nio.entity.ContentBufferEntity;
import conductor.org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import conductor.org.apache.http.nio.util.ByteBufferAllocator;
import conductor.org.apache.http.nio.util.HeapByteBufferAllocator;
import conductor.org.apache.http.nio.util.SimpleInputBuffer;
import conductor.org.apache.http.protocol.HttpContext;
import java.io.IOException;

public class HeapBufferedAsyncResponseConsumer
extends AbstractAsyncResponseConsumer<HttpResponse> {
    private final int bufferLimitBytes;
    private volatile HttpResponse response;
    private volatile SimpleInputBuffer buf;

    public HeapBufferedAsyncResponseConsumer(int bufferLimit) {
        if (bufferLimit <= 0) {
            throw new IllegalArgumentException("bufferLimit must be greater than 0");
        }
        this.bufferLimitBytes = bufferLimit;
    }

    public int getBufferLimit() {
        return this.bufferLimitBytes;
    }

    @Override
    protected void onResponseReceived(HttpResponse response) throws HttpException, IOException {
        this.response = response;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > (long)this.bufferLimitBytes) {
            throw new ContentTooLongException("entity content is too long [" + len + "] for the configured buffer limit [" + this.bufferLimitBytes + "]");
        }
        if (len < 0L) {
            len = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)len, this.getByteBufferAllocator());
        this.response.setEntity(new ContentBufferEntity(entity, this.buf));
    }

    protected ByteBufferAllocator getByteBufferAllocator() {
        return HeapByteBufferAllocator.INSTANCE;
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        this.buf.consumeContent(decoder);
    }

    @Override
    protected HttpResponse buildResult(HttpContext context) throws Exception {
        return this.response;
    }

    @Override
    protected void releaseResources() {
        this.response = null;
    }
}

