/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.io.stream;

import conductor.org.elasticsearch.common.io.stream.FilterStreamInput;
import conductor.org.elasticsearch.common.io.stream.NamedWriteable;
import conductor.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import java.io.IOException;

public class NamedWriteableAwareStreamInput
extends FilterStreamInput {
    private final NamedWriteableRegistry namedWriteableRegistry;

    public NamedWriteableAwareStreamInput(StreamInput delegate, NamedWriteableRegistry namedWriteableRegistry) {
        super(delegate);
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    @Override
    public <C extends NamedWriteable> C readNamedWriteable(Class<C> categoryClass) throws IOException {
        String name = this.readString();
        return this.readNamedWriteable(categoryClass, name);
    }

    @Override
    public <C extends NamedWriteable> C readNamedWriteable(Class<C> categoryClass, String name) throws IOException {
        Writeable.Reader<C> reader = this.namedWriteableRegistry.getReader(categoryClass, name);
        NamedWriteable c = (NamedWriteable)reader.read(this);
        if (c == null) {
            throw new IOException("Writeable.Reader [" + reader + "] returned null which is not allowed and probably means it screwed up the stream.");
        }
        assert (name.equals(c.getWriteableName())) : c + " claims to have a different name [" + c.getWriteableName() + "] than it was read from [" + name + "].";
        return (C)c;
    }
}

